# Keyboard Shortcuts

Modifier `menu` corresponds to `ctrl` on Linux (L) and Windows (W), 
and `meta` or command on Mac (M).

## Common

|**Key**            |**Action**                         |
|:------------------|:----------------------------------|
|`menu 1`           |Add new element (command line)     |
|`menu N`           |Add new element (popup selection)  |
|`menu BACKSPACE`   |Delete element                     |
|`menu ENTER`       |Open element viewer                |
|`menu SEMICOLON`   |Open element's attribute map       |
|`menu PLUS`        |Zoom in                            |
|`menu MINUS`       |Zoom out                           |
|`menu 0`           |Reset zoom level                   |
|`menu P`           |Show log window                    |
|`shift menu P`     |Clear log window                   |
|`menu W`           |Close window                       |
|`alt LEFT`         |Move to previous tab               |
|`alt RIGHT`        |Move to next tab                   |

## Code Editors

We try to use the same keyboard mappings as IntelliJ IDEA, with some additional mappings inspired by SuperCollider.

|**Key**            |**Action**                         |
|:------------------|:----------------------------------|
|`ESCAPE`           |Clear selection and highlights     |
|`INSERT`           |Toggle insert and overwrite modes  |
|`TAB`              |Increase indentation               |
|`shift TAB`        |Decrease indentation               |
|`menu PLUS`        |Increase font size                 |
|`menu MINUS`       |Decrease font size                 |
|`menu 0`           |Reset font size                    |
|`menu A`           |Select all                         |
|`menu X`           |Cut to clipboard                   |
|`menu C`           |Copy to clipboard                  |
|`menu V`           |Paste from clipboard               |
|`menu Z`           |Undo                               |
|`shift menu Z`     |Redo                               |
|`menu B`           |Go to declaration                  |
|`menu D`           |Duplicate line                     |
|`ctrl Y`           |(L,W) Remove line                  |
|`meta BACKSPACE`   |(M)   Remove line                  |
|`ctrl UP`          |Scroll up (back)                   |
|`ctrl DOWN`        |Scroll down (forward)              |
|`menu SLASH`       |Toggle line comment                |
|`ctrl SPACE`       |Trigger code completion            |
|`ctrl alt S`       |Toggle vertical split (*)          |
|`shift menu UP`    |Move line up                       |
|`shift menu DOWN`  |Move line down                     |
|`shift menu F7`    |Show usages                        |
|`ctrl LEFT`        |Move to word start                 |
|`ctrl RIGHT`       |Move to word end                   |
|`ctrl BACKSPACE`   |Delete to word start               |
|`ctrl DELETE`      |Delete to word end                 |
|`menu F9`          |Compile or build project           |
|`ctrl alt D`       |Documentation for cursor           |
|`menu S`           |Compile and save code              |
|`shift RETURN`     |Execute selection in interpreter   |

(*) Currently not implemented

## Transport and temporal navigation

|**Key**                  |**Action**                                        |
|:------------------------|:-------------------------------------------------|
|`SPACE`                  |Play and stop                                     |
|`ENTER`                  |Go to beginning                                   |
|`G`                      |Set-Cursor-Position dialog                        |
|`OPEN_BRACKET`           |Cue rewind                                        |
|`CLOSE_BRACKET`          |Cue fast forward                                  |
|`SLASH`                  |Toggle loop                                       |
|`V`                      |Toggle catch (scroll with transport)              |
|`shift OPEN_BRACKET`     |Extend selection to the left                      |
|`shift CLOSE_BRACKET`    |Extend selection to the right                     |
|`LEFT`                   |Move position to selection start, clear selection |
|`RIGHT`                  |Move position to selection end, clear selection   |
|`alt LEFT`               |Move position to selection start                  |
|`alt RIGHT`              |Move position to selection end                    |
|`ctrl LEFT`              |Zoom out                                          |
|`ctrl RIGHT`             |Zoom in                                           |
|`ctrl alt LEFT`, `alt A` |Zoom all the way out                              |
|`alt F`                  |Zoom to selection                                 |

## Timeline editor

|**Key**            |**Action**                         |
|:------------------|:----------------------------------|
|`1` to `9`         |Select timeline tools              |
|`ESCAPE`           |Cancel ongoing tool edit           |
|`M`                |Drop marker at current position    |

## Grapheme editor

|**Key**                  |**Action**                                        |
|:------------------------|:-------------------------------------------------|
|`ctrl UP`, `ctrl DOWN`   |increase or decrease vertical zoom                |

## Oscilloscope

|**Key**                  |**Action**                                                   |
|:------------------------|:------------------------------------------------------------|
|`ctrl UP`, `ctrl DOWN`   |increase or decrease vertical zoom                           |
|`ctrl RIGHT`, `ctrl LEFT`|increase or decrease horizontal zoom                         |
|`SPACE`                  |toggle run/pause                                             |
|`PERIOD`                 |pause                                                        |
|`J`, `L`                 |decrease or increase channel offset                          |
|`shift J`, `shift L`     |decrease or increase number of channels                      |
|`K`                      |switch between audio and control rate buses                  |
|`I`, `O`                 |switch to audio inputs and audio outputs                     |
|`S`                      |switch between parallel and overlay mode                     |
|`shift S`                |switch between Lissajous (X/Y) and normal (X over time) mode |
