/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.secure_sm.policy;

import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.ArrayDeque;
import java.util.Deque;
import org.opensearch.secure_sm.policy.Token;
import org.opensearch.secure_sm.policy.Tokenizer;

public class TokenStream {
    private final StreamTokenizer tokenizer;
    private final Deque<Token> buffer = new ArrayDeque<Token>();

    TokenStream(Reader reader) {
        this.tokenizer = Tokenizer.configureTokenizer(reader);
    }

    Token peek() throws IOException {
        if (this.buffer.isEmpty()) {
            this.buffer.push(this.nextToken());
        }
        return this.buffer.peek();
    }

    Token consume() throws IOException {
        return this.buffer.isEmpty() ? this.nextToken() : this.buffer.pop();
    }

    boolean isEOF() throws IOException {
        Token t = this.peek();
        return t.type() == -1;
    }

    int line() throws IOException {
        return this.peek().line();
    }

    private Token nextToken() throws IOException {
        int type = this.tokenizer.nextToken();
        String text = switch (type) {
            case -3, 34, 39 -> this.tokenizer.sval;
            case -1 -> "<EOF>";
            default -> Character.toString((char)type);
        };
        return new Token(type, text, this.tokenizer.lineno());
    }
}

