/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.analysis.common;

import org.apache.lucene.analysis.TokenStream;
import org.opensearch.analysis.common.UniqueTokenFilter;
import org.opensearch.common.settings.Settings;
import org.opensearch.env.Environment;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.analysis.AbstractTokenFilterFactory;

public class UniqueTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final boolean onlyOnSamePosition;

    UniqueTokenFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.onlyOnSamePosition = settings.getAsBoolean("only_on_same_position", Boolean.valueOf(false));
    }

    public TokenStream create(TokenStream tokenStream) {
        return new UniqueTokenFilter(tokenStream, this.onlyOnSamePosition);
    }
}

