/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.streamingingestion.state;

import java.io.IOException;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.action.admin.indices.streamingingestion.resume.ResumeIngestionRequest;
import org.opensearch.action.support.broadcast.BroadcastRequest;
import org.opensearch.common.Nullable;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;

@ExperimentalApi
public class UpdateIngestionStateRequest
extends BroadcastRequest<UpdateIngestionStateRequest> {
    private String[] index;
    private int[] shards;
    @Nullable
    private Boolean ingestionPaused;
    @Nullable
    private ResumeIngestionRequest.ResetSettings[] resetSettings;

    public UpdateIngestionStateRequest(String[] index, int[] shards) {
        super(new String[0]);
        this.index = index;
        this.shards = shards;
    }

    public UpdateIngestionStateRequest(StreamInput in) throws IOException {
        super(in);
        this.index = in.readStringArray();
        this.shards = in.readVIntArray();
        this.ingestionPaused = in.readOptionalBoolean();
        this.resetSettings = (ResumeIngestionRequest.ResetSettings[])in.readOptionalArray(ResumeIngestionRequest.ResetSettings::new, ResumeIngestionRequest.ResetSettings[]::new);
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.index == null) {
            validationException = ValidateActions.addValidationError("index is missing", validationException);
        }
        return validationException;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.index);
        out.writeVIntArray(this.shards);
        out.writeOptionalBoolean(this.ingestionPaused);
        out.writeOptionalArray((Writeable[])this.resetSettings);
    }

    public String[] getIndex() {
        return this.index;
    }

    public int[] getShards() {
        return this.shards;
    }

    public void setShards(int[] shards) {
        this.shards = shards;
    }

    public Boolean getIngestionPaused() {
        return this.ingestionPaused;
    }

    public void setIngestionPaused(boolean ingestionPaused) {
        this.ingestionPaused = ingestionPaused;
    }

    @Nullable
    public ResumeIngestionRequest.ResetSettings[] getResetSettings() {
        return this.resetSettings;
    }

    public void setResetSettings(ResumeIngestionRequest.ResetSettings[] resetSettings) {
        this.resetSettings = resetSettings;
    }
}

