/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.cache.stats;

import java.util.Objects;
import org.opensearch.common.cache.stats.ImmutableCacheStats;
import org.opensearch.common.metrics.CounterMetric;

public class CacheStats {
    CounterMetric hits = new CounterMetric();
    CounterMetric misses;
    CounterMetric evictions;
    CounterMetric sizeInBytes;
    CounterMetric items;

    public CacheStats(long hits, long misses, long evictions, long sizeInBytes, long items) {
        this.hits.inc(hits);
        this.misses = new CounterMetric();
        this.misses.inc(misses);
        this.evictions = new CounterMetric();
        this.evictions.inc(evictions);
        this.sizeInBytes = new CounterMetric();
        this.sizeInBytes.inc(sizeInBytes);
        this.items = new CounterMetric();
        this.items.inc(items);
    }

    public CacheStats() {
        this(0L, 0L, 0L, 0L, 0L);
    }

    private void internalAdd(long otherHits, long otherMisses, long otherEvictions, long otherSizeInBytes, long otherEntries) {
        this.hits.inc(otherHits);
        this.misses.inc(otherMisses);
        this.evictions.inc(otherEvictions);
        this.sizeInBytes.inc(otherSizeInBytes);
        this.items.inc(otherEntries);
    }

    public void add(CacheStats other) {
        if (other == null) {
            return;
        }
        this.internalAdd(other.getHits(), other.getMisses(), other.getEvictions(), other.getSizeInBytes(), other.getItems());
    }

    public void add(ImmutableCacheStats snapshot) {
        if (snapshot == null) {
            return;
        }
        this.internalAdd(snapshot.getHits(), snapshot.getMisses(), snapshot.getEvictions(), snapshot.getSizeInBytes(), snapshot.getItems());
    }

    public void subtract(ImmutableCacheStats other) {
        if (other == null) {
            return;
        }
        this.internalAdd(-other.getHits(), -other.getMisses(), -other.getEvictions(), -other.getSizeInBytes(), -other.getItems());
    }

    public int hashCode() {
        return Objects.hash(this.hits.count(), this.misses.count(), this.evictions.count(), this.sizeInBytes.count(), this.items.count());
    }

    public void incrementHits() {
        this.hits.inc();
    }

    public void incrementMisses() {
        this.misses.inc();
    }

    public void incrementEvictions() {
        this.evictions.inc();
    }

    public void incrementSizeInBytes(long amount) {
        this.sizeInBytes.inc(amount);
    }

    public void decrementSizeInBytes(long amount) {
        this.sizeInBytes.dec(amount);
    }

    public void incrementItems() {
        this.items.inc();
    }

    public void decrementItems() {
        this.items.dec();
    }

    public long getHits() {
        return this.hits.count();
    }

    public long getMisses() {
        return this.misses.count();
    }

    public long getEvictions() {
        return this.evictions.count();
    }

    public long getSizeInBytes() {
        return this.sizeInBytes.count();
    }

    public long getItems() {
        return this.items.count();
    }

    public void resetSizeAndEntries() {
        this.sizeInBytes = new CounterMetric();
        this.items = new CounterMetric();
    }

    public ImmutableCacheStats immutableSnapshot() {
        return new ImmutableCacheStats(this.hits.count(), this.misses.count(), this.evictions.count(), this.sizeInBytes.count(), this.items.count());
    }
}

