/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.util;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.Randomness;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.TimeoutAwareRunnable;

public class BatchRunnableExecutor
implements Runnable {
    private final Supplier<TimeValue> timeoutSupplier;
    private final List<TimeoutAwareRunnable> timeoutAwareRunnables;
    private static final Logger logger = LogManager.getLogger(BatchRunnableExecutor.class);

    public BatchRunnableExecutor(List<TimeoutAwareRunnable> timeoutAwareRunnables, Supplier<TimeValue> timeoutSupplier) {
        this.timeoutSupplier = timeoutSupplier;
        this.timeoutAwareRunnables = timeoutAwareRunnables;
    }

    public List<TimeoutAwareRunnable> getTimeoutAwareRunnables() {
        return this.timeoutAwareRunnables;
    }

    @Override
    public void run() {
        logger.debug("Starting execution of runnable of size [{}]", (Object)this.timeoutAwareRunnables.size());
        long startTime = System.nanoTime();
        if (this.timeoutAwareRunnables.isEmpty()) {
            return;
        }
        Randomness.shuffle(this.timeoutAwareRunnables);
        for (TimeoutAwareRunnable runnable : this.timeoutAwareRunnables) {
            if (this.timeoutSupplier.get().nanos() < 0L || System.nanoTime() - startTime < this.timeoutSupplier.get().nanos()) {
                runnable.run();
                continue;
            }
            logger.debug("Executing timeout for runnable of size [{}]", (Object)this.timeoutAwareRunnables.size());
            runnable.onTimeout();
        }
        logger.debug("Time taken to execute timed runnables in this cycle:[{}ms]", (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime));
        this.onComplete();
    }

    public void onComplete() {
    }
}

