/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.compositeindex.datacube;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.xcontent.support.XContentMapValues;
import org.opensearch.index.compositeindex.datacube.DateDimension;
import org.opensearch.index.compositeindex.datacube.Dimension;
import org.opensearch.index.compositeindex.datacube.IpDimension;
import org.opensearch.index.compositeindex.datacube.NumericDimension;
import org.opensearch.index.compositeindex.datacube.OrdinalDimension;
import org.opensearch.index.compositeindex.datacube.UnsignedLongDimension;
import org.opensearch.index.compositeindex.datacube.startree.StarTreeIndexSettings;
import org.opensearch.index.compositeindex.datacube.startree.utils.date.DateTimeUnitRounding;
import org.opensearch.index.mapper.DateFieldMapper;
import org.opensearch.index.mapper.Mapper;

@ExperimentalApi
public class DimensionFactory {
    public static Dimension parseAndCreateDimension(String name, String type, Map<String, Object> dimensionMap, Mapper.TypeParser.ParserContext c) {
        switch (type) {
            case "date": {
                return DimensionFactory.parseAndCreateDateDimension(name, dimensionMap, c);
            }
            case "numeric": {
                return new NumericDimension(name);
            }
            case "unsigned_long": {
                return new UnsignedLongDimension(name);
            }
            case "ordinal": {
                return new OrdinalDimension(name);
            }
            case "ip": {
                return new IpDimension(name);
            }
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "unsupported field type associated with dimension [%s] as part of star tree field", name));
    }

    public static Dimension parseAndCreateDimension(String name, Mapper.Builder builder, Map<String, Object> dimensionMap, Mapper.TypeParser.ParserContext c) {
        if (builder.getSupportedDataCubeDimensionType().isEmpty()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "unsupported field type associated with star tree dimension [%s]", name));
        }
        switch (builder.getSupportedDataCubeDimensionType().get()) {
            case DATE: {
                return DimensionFactory.parseAndCreateDateDimension(name, dimensionMap, c);
            }
            case NUMERIC: {
                return new NumericDimension(name);
            }
            case UNSIGNED_LONG: {
                return new UnsignedLongDimension(name);
            }
            case ORDINAL: {
                return new OrdinalDimension(name);
            }
            case IP: {
                return new IpDimension(name);
            }
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "unsupported field type associated with star tree dimension [%s]", name));
    }

    private static DateDimension parseAndCreateDateDimension(String name, Map<String, Object> dimensionMap, Mapper.TypeParser.ParserContext c) {
        LinkedHashSet<DateTimeUnitRounding> calendarIntervals;
        List intervalStrings = XContentMapValues.extractRawValues("calendar_intervals", dimensionMap).stream().map(Object::toString).collect(Collectors.toList());
        if (intervalStrings == null || intervalStrings.isEmpty()) {
            calendarIntervals = new LinkedHashSet<DateTimeUnitRounding>((Collection)StarTreeIndexSettings.DEFAULT_DATE_INTERVALS.get(c.getSettings()));
        } else {
            if (intervalStrings.size() > StarTreeIndexSettings.STAR_TREE_MAX_DATE_INTERVALS_SETTING.get(c.getSettings())) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "At most [%s] calendar intervals are allowed in dimension [%s]", StarTreeIndexSettings.STAR_TREE_MAX_DATE_INTERVALS_SETTING.get(c.getSettings()), name));
            }
            calendarIntervals = new LinkedHashSet();
            for (String interval : intervalStrings) {
                calendarIntervals.add(StarTreeIndexSettings.getTimeUnit(interval));
            }
        }
        dimensionMap.remove("calendar_intervals");
        DateFieldMapper.Resolution resolution = null;
        if (c != null && c.mapperService() != null && c.mapperService().fieldType(name) != null) {
            resolution = ((DateFieldMapper.DateFieldType)c.mapperService().fieldType(name)).resolution();
        }
        return new DateDimension(name, new ArrayList<DateTimeUnitRounding>(calendarIntervals), resolution);
    }
}

