/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.similarity;

import org.apache.lucene.search.similarities.Similarity;
import org.opensearch.Version;
import org.opensearch.common.TriFunction;
import org.opensearch.common.settings.Settings;
import org.opensearch.index.similarity.ScriptedSimilarity;
import org.opensearch.script.Script;
import org.opensearch.script.ScriptService;
import org.opensearch.script.SimilarityScript;
import org.opensearch.script.SimilarityWeightScript;

final class ScriptedSimilarityProvider
implements TriFunction<Settings, Version, ScriptService, Similarity> {
    ScriptedSimilarityProvider() {
    }

    public Similarity apply(Settings settings, Version indexCreatedVersion, ScriptService scriptService) {
        boolean discountOverlaps = settings.getAsBoolean("discount_overlaps", true);
        Settings scriptSettings = settings.getAsSettings("script");
        Script script = Script.parse(scriptSettings);
        SimilarityScript.Factory scriptFactory = scriptService.compile(script, SimilarityScript.CONTEXT);
        Settings weightScriptSettings = settings.getAsSettings("weight_script");
        Script weightScript = null;
        SimilarityWeightScript.Factory weightScriptFactory = null;
        if (!weightScriptSettings.isEmpty()) {
            weightScript = Script.parse(weightScriptSettings);
            weightScriptFactory = scriptService.compile(weightScript, SimilarityWeightScript.CONTEXT);
        }
        return new ScriptedSimilarity(weightScript == null ? null : weightScript.toString(), weightScriptFactory == null ? null : weightScriptFactory::newInstance, script.toString(), scriptFactory::newInstance, discountOverlaps);
    }
}

