/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.store.remote.utils.cache.stats;

import java.util.Objects;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.index.store.remote.utils.cache.stats.IRefCountedCacheStats;

@PublicApi(since="2.7.0")
public final class RefCountedCacheStats
implements IRefCountedCacheStats {
    private long hitCount;
    private long missCount;
    private long removeCount;
    private long removeWeight;
    private long replaceCount;
    private long evictionCount;
    private long evictionWeight;
    private long usage;
    private long activeUsage;
    private long pinnedUsage;

    public RefCountedCacheStats(long hitCount, long missCount, long removeCount, long removeWeight, long replaceCount, long evictionCount, long evictionWeight, long usage, long activeUsage, long pinnedUsage) {
        if (hitCount < 0L || missCount < 0L || removeCount < 0L || removeWeight < 0L || replaceCount < 0L || evictionCount < 0L || evictionWeight < 0L) {
            throw new IllegalArgumentException();
        }
        this.hitCount = hitCount;
        this.missCount = missCount;
        this.removeCount = removeCount;
        this.removeWeight = removeWeight;
        this.replaceCount = replaceCount;
        this.evictionCount = evictionCount;
        this.evictionWeight = evictionWeight;
        this.usage = usage;
        this.activeUsage = activeUsage;
        this.pinnedUsage = pinnedUsage;
    }

    @Override
    public long requestCount() {
        return this.hitCount + this.missCount;
    }

    @Override
    public long hitCount() {
        return this.hitCount;
    }

    @Override
    public double hitRate() {
        long requestCount = this.requestCount();
        return requestCount == 0L ? 1.0 : (double)this.hitCount / (double)requestCount;
    }

    @Override
    public long missCount() {
        return this.missCount;
    }

    @Override
    public double missRate() {
        long requestCount = this.requestCount();
        return requestCount == 0L ? 0.0 : (double)this.missCount / (double)requestCount;
    }

    @Override
    public long removeCount() {
        return this.removeCount;
    }

    @Override
    public long removeWeight() {
        return this.removeWeight;
    }

    @Override
    public long replaceCount() {
        return this.replaceCount;
    }

    @Override
    public long evictionCount() {
        return this.evictionCount;
    }

    @Override
    public long evictionWeight() {
        return this.evictionWeight;
    }

    @Override
    public long usage() {
        return this.usage;
    }

    @Override
    public long activeUsage() {
        return this.activeUsage;
    }

    @Override
    public long pinnedUsage() {
        return this.pinnedUsage;
    }

    @Override
    public IRefCountedCacheStats accumulate(IRefCountedCacheStats other) {
        if (!(other instanceof RefCountedCacheStats)) {
            throw new IllegalArgumentException("Invalid Argument passed for Accumulating RefCountedCacheStats");
        }
        RefCountedCacheStats otherStats = (RefCountedCacheStats)other;
        this.hitCount += otherStats.hitCount();
        this.missCount += otherStats.missCount();
        this.removeCount += otherStats.removeCount();
        this.removeWeight += otherStats.removeWeight();
        this.replaceCount += otherStats.replaceCount();
        this.evictionCount += otherStats.evictionCount();
        this.evictionWeight += otherStats.evictionWeight();
        this.usage += otherStats.usage();
        this.activeUsage += otherStats.activeUsage();
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.hitCount, this.missCount, this.removeCount, this.removeWeight, this.replaceCount, this.evictionCount, this.evictionWeight, this.usage, this.activeUsage);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RefCountedCacheStats)) {
            return false;
        }
        RefCountedCacheStats other = (RefCountedCacheStats)o;
        return this.hitCount == other.hitCount && this.missCount == other.missCount && this.removeCount == other.removeCount && this.removeWeight == other.removeWeight && this.replaceCount == other.replaceCount && this.evictionCount == other.evictionCount && this.evictionWeight == other.evictionWeight && this.usage == other.usage && this.activeUsage == other.activeUsage && this.pinnedUsage == other.pinnedUsage;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{hitCount=" + this.hitCount + ", missCount=" + this.missCount + ", removeCount=" + this.removeCount + ", removeWeight=" + this.removeWeight + ", replaceCount=" + this.replaceCount + ", evictionCount=" + this.evictionCount + ", evictionWeight=" + this.evictionWeight + ", usage=" + this.usage + ", activeUsage=" + this.activeUsage + ", pinnedUsage=" + this.pinnedUsage + "}";
    }
}

