/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.admin.cluster;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import org.opensearch.action.admin.cluster.stats.ClusterStatsRequest;
import org.opensearch.action.admin.cluster.stats.ClusterStatsResponse;
import org.opensearch.core.common.Strings;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestActions;
import org.opensearch.transport.client.node.NodeClient;

public class RestClusterStatsAction
extends BaseRestHandler {
    static final Map<String, Consumer<ClusterStatsRequest>> INDEX_METRIC_TO_REQUEST_CONSUMER_MAP;
    static final Map<String, Consumer<ClusterStatsRequest>> METRIC_REQUEST_CONSUMER_MAP;

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_cluster/stats"), new RestHandler.Route(RestRequest.Method.GET, "/_cluster/stats/nodes/{nodeId}"), new RestHandler.Route(RestRequest.Method.GET, "/_cluster/stats/{metric}/nodes/{nodeId}"), new RestHandler.Route(RestRequest.Method.GET, "/_cluster/stats/{metric}/{index_metric}/nodes/{nodeId}")));
    }

    @Override
    public String getName() {
        return "cluster_stats_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        ClusterStatsRequest clusterStatsRequest = RestClusterStatsAction.fromRequest(request);
        return channel -> client.admin().cluster().clusterStats(clusterStatsRequest, new RestActions.NodesResponseRestListener<ClusterStatsResponse>((RestChannel)channel));
    }

    public static ClusterStatsRequest fromRequest(RestRequest request) {
        HashSet<String> indexMetricsRequested;
        Set<String> invalidIndexMetrics;
        Set metrics = Strings.tokenizeByCommaToSet((String)request.param("metric", "_all"));
        String indicesMetricsDefaultValue = metrics.contains(ClusterStatsRequest.Metric.INDICES.metricName()) || metrics.contains("_all") ? "_all" : null;
        Set indexMetrics = Strings.tokenizeByCommaToSet((String)request.param("index_metric", indicesMetricsDefaultValue));
        String[] nodeIds = request.paramAsStringArray("nodeId", null);
        ClusterStatsRequest clusterStatsRequest = (ClusterStatsRequest)new ClusterStatsRequest(new String[0]).nodesIds(nodeIds);
        clusterStatsRequest.timeout(request.param("timeout"));
        clusterStatsRequest.useAggregatedNodeLevelResponses(true);
        clusterStatsRequest.computeAllMetrics(false);
        RestClusterStatsAction.paramValidations(metrics, indexMetrics, request);
        HashSet<String> metricsRequested = metrics.contains("_all") ? new HashSet<String>(METRIC_REQUEST_CONSUMER_MAP.keySet()) : new HashSet(metrics);
        Set<String> invalidMetrics = RestClusterStatsAction.validateAndSetRequestedMetrics(metricsRequested, METRIC_REQUEST_CONSUMER_MAP, clusterStatsRequest);
        if (!invalidMetrics.isEmpty()) {
            throw new IllegalArgumentException(RestClusterStatsAction.unrecognizedStrings(request, invalidMetrics, METRIC_REQUEST_CONSUMER_MAP.keySet(), "metric"));
        }
        if (metricsRequested.contains(ClusterStatsRequest.Metric.INDICES.metricName()) && !(invalidIndexMetrics = RestClusterStatsAction.validateAndSetRequestedMetrics(indexMetricsRequested = indexMetrics.contains("_all") ? INDEX_METRIC_TO_REQUEST_CONSUMER_MAP.keySet() : new HashSet<String>(indexMetrics), INDEX_METRIC_TO_REQUEST_CONSUMER_MAP, clusterStatsRequest)).isEmpty()) {
            throw new IllegalArgumentException(RestClusterStatsAction.unrecognizedStrings(request, invalidIndexMetrics, INDEX_METRIC_TO_REQUEST_CONSUMER_MAP.keySet(), "index metric"));
        }
        return clusterStatsRequest;
    }

    private static void paramValidations(Set<String> metrics, Set<String> indexMetrics, RestRequest request) {
        if (metrics.size() > 1 && metrics.contains("_all")) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "request [%s] contains _all and individual metrics [%s]", request.path(), request.param("metric")));
        }
        if (indexMetrics.size() > 1 && indexMetrics.contains("_all")) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "request [%s] contains _all and individual index metrics [%s]", request.path(), request.param("index_metric")));
        }
        if (!(metrics.contains(ClusterStatsRequest.Metric.INDICES.metricName()) || metrics.contains("_all") || indexMetrics.isEmpty())) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "request [%s] contains index metrics [%s] but indices stats not requested", request.path(), request.param("index_metric")));
        }
    }

    private static Set<String> validateAndSetRequestedMetrics(Set<String> metrics, Map<String, Consumer<ClusterStatsRequest>> metricConsumerMap, ClusterStatsRequest clusterStatsRequest) {
        TreeSet<String> invalidMetrics = new TreeSet<String>();
        for (String metric : metrics) {
            Consumer<ClusterStatsRequest> clusterStatsRequestConsumer = metricConsumerMap.get(metric);
            if (clusterStatsRequestConsumer != null) {
                clusterStatsRequestConsumer.accept(clusterStatsRequest);
                continue;
            }
            invalidMetrics.add(metric);
        }
        return invalidMetrics;
    }

    @Override
    public boolean canTripCircuitBreaker() {
        return false;
    }

    private static /* synthetic */ void lambda$static$1(ClusterStatsRequest.IndexMetric indexMetric, ClusterStatsRequest request) {
        request.addIndexMetric(indexMetric);
    }

    static {
        HashMap<String, Consumer<ClusterStatsRequest>> metricRequestConsumerMap = new HashMap<String, Consumer<ClusterStatsRequest>>();
        for (ClusterStatsRequest.Metric metric : ClusterStatsRequest.Metric.values()) {
            metricRequestConsumerMap.put(metric.metricName(), request -> request.addMetric(metric));
        }
        METRIC_REQUEST_CONSUMER_MAP = Collections.unmodifiableMap(metricRequestConsumerMap);
        HashMap<String, Consumer<ClusterStatsRequest>> metricMap = new HashMap<String, Consumer<ClusterStatsRequest>>();
        for (Enum enum_ : ClusterStatsRequest.IndexMetric.values()) {
            metricMap.put(((ClusterStatsRequest.IndexMetric)enum_).metricName(), arg_0 -> RestClusterStatsAction.lambda$static$1((ClusterStatsRequest.IndexMetric)enum_, arg_0));
        }
        INDEX_METRIC_TO_REQUEST_CONSUMER_MAP = Collections.unmodifiableMap(metricMap);
    }
}

