/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.startree.filter;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.index.compositeindex.datacube.Dimension;
import org.opensearch.index.compositeindex.datacube.startree.index.StarTreeValues;
import org.opensearch.index.compositeindex.datacube.startree.node.StarTreeNode;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.search.startree.StarTreeNodeCollector;
import org.opensearch.search.startree.StarTreeQueryHelper;
import org.opensearch.search.startree.filter.DimensionFilter;
import org.opensearch.search.startree.filter.provider.DimensionFilterMapper;

@ExperimentalApi
public class ExactMatchDimFilter
implements DimensionFilter {
    private final String dimensionName;
    private final List<Object> rawValues;
    private TreeSet<Long> convertedOrdinals;
    private DimensionFilterMapper dimensionFilterMapper;

    public ExactMatchDimFilter(String dimensionName, List<Object> valuesToMatch) {
        this.dimensionName = dimensionName;
        this.rawValues = valuesToMatch;
    }

    @Override
    public void initialiseForSegment(StarTreeValues starTreeValues, SearchContext searchContext) {
        this.convertedOrdinals = new TreeSet();
        Dimension matchedDim = StarTreeQueryHelper.getMatchingDimensionOrThrow(this.dimensionName, starTreeValues.getStarTreeField().getDimensionsOrder());
        this.dimensionFilterMapper = DimensionFilterMapper.Factory.fromMappedFieldType(searchContext.mapperService().fieldType(this.dimensionName), searchContext);
        for (Object rawValue : this.rawValues) {
            Optional<Long> ordinal = this.dimensionFilterMapper.getMatchingOrdinal(matchedDim.getField(), rawValue, starTreeValues, DimensionFilter.MatchType.EXACT);
            ordinal.ifPresent(aLong -> this.convertedOrdinals.add((Long)aLong));
        }
    }

    @Override
    public void matchStarTreeNodes(StarTreeNode parentNode, StarTreeValues starTreeValues, StarTreeNodeCollector collector) throws IOException {
        if (parentNode != null) {
            StarTreeNode lastMatchedNode = null;
            for (long ordinal : this.convertedOrdinals) {
                lastMatchedNode = parentNode.getChildForDimensionValue(ordinal, lastMatchedNode, this.dimensionFilterMapper);
                if (lastMatchedNode == null) continue;
                collector.collectStarTreeNode(lastMatchedNode);
            }
        }
    }

    @Override
    public boolean matchDimValue(long ordinal, StarTreeValues starTreeValues) {
        return this.convertedOrdinals.contains(ordinal);
    }

    public List<Object> getRawValues() {
        return this.rawValues;
    }

    @Override
    public String getDimensionName() {
        return this.dimensionName;
    }
}

