/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.translate;

import java.util.Map;

public final class ArgumentsUtil {
    private ArgumentsUtil() {
    }

    public static String stringValue(Map<String, ?> arguments, String key) {
        return ArgumentsUtil.stringValue(arguments, key, null);
    }

    public static String stringValue(Map<String, ?> arguments, String key, String def) {
        Object value = arguments.get(key);
        if (value == null) {
            return def;
        }
        return value.toString();
    }

    public static int intValue(Map<String, ?> arguments, String key) {
        return ArgumentsUtil.intValue(arguments, key, 0);
    }

    public static int intValue(Map<String, ?> arguments, String key, int def) {
        Object value = arguments.get(key);
        if (value == null) {
            return def;
        }
        return (int)Double.parseDouble(value.toString());
    }

    public static long longValue(Map<String, ?> arguments, String key) {
        return ArgumentsUtil.longValue(arguments, key, 0L);
    }

    public static Long longValue(Map<String, ?> arguments, String key, long def) {
        Object value = arguments.get(key);
        if (value == null) {
            return def;
        }
        return (long)Double.parseDouble(value.toString());
    }

    public static float floatValue(Map<String, ?> arguments, String key) {
        return ArgumentsUtil.floatValue(arguments, key, 0.0f);
    }

    public static float floatValue(Map<String, ?> arguments, String key, float def) {
        Object value = arguments.get(key);
        if (value == null) {
            return def;
        }
        return (float)Double.parseDouble(value.toString());
    }

    public static boolean booleanValue(Map<String, ?> arguments, String key) {
        return ArgumentsUtil.booleanValue(arguments, key, false);
    }

    public static boolean booleanValue(Map<String, ?> arguments, String key, boolean def) {
        Object value = arguments.get(key);
        if (value == null) {
            return def;
        }
        return Boolean.parseBoolean(value.toString());
    }
}

