-- Copyright © 2008-2025 Pioneer Developers. See AUTHORS.txt for details
-- Licensed under the terms of the GPL v3. See licenses/GPL-3.txt

-- Basque names

-- References
-- https://en.wikipedia.org/wiki/Basque_surnames
-- https://en.wikipedia.org/wiki/Category:Basque-language_surnames
-- https://en.wikipedia.org/wiki/Culture_of_the_Basque_Country
-- https://en.wikipedia.org/wiki/Category:Basque_feminine_given_names
-- https://en.wikipedia.org/wiki/Category:Basque_masculine_given_names

local CultureName = require './common'

local male = {
    "Aimar",
    "Aitor",
    "Andoni",
    "Antolin",
    "Antton",
    "Antxon",
    "Asier",
    "Beñat",
    "Eneko",
    "Gaizka",
    "Gorka",
    "Gotzon",
    "Ibai",
    "Iker",
    "Imanol",
    "Iñaki",
    "Jimeno",
    "Jokin",
    "Joseba",
    "Josetxu",
    "Josu",
    "Joxe",
    "Karlo",
    "Karlos",
    "Karol",
    "Koldo",
    "Mikel",
    "Oier",
    "Patxi",
    "Sancho",
    "Txiki",
    "Txomin",
    "Unai",
    "Urko",
    "Urtzi",
    "Victor",
    "Xavier",
}

local female = {
    "Ainara",
    "Ainhoa",
    "Alazne",
    "Amaia",
    "Amane",
    "Amaya",
    "Ana",
    "Anabel",
    "Arantxa",
    "Atenea",
    "Aurora",
    "Begoña",
    "Elena",
    "Esti",
    "Garbiñe",
    "Irati",
    "Itziar",
    "Izaro",
    "Jone",
    "Josune",
    "June",
    "Leire",
    "Maider",
    "Maitane",
    "Maite",
    "Miren",
    "Nerea",
    "Oihane",
    "Olatz",
    "Susana",
    "Usue",
    "Uxue",
    "Yolanda",
    "Zuriñe",
}

local surname = {
    "Abadiano",
    "Abasolo",
    "Abaunza",
    "Agerre",
    "Agirre",
    "Aguerre",
    "Aguinaga",
    "Aguirre",
    "Aispuro",
    "Aiza",
    "Alberdi",
    "Albizu",
    "Albizuri",
    "Alcorta",
    "Alkorta",
    "Allende",
    "Alsogaray",
    "Alzaga",
    "Amenábar",
    "Amescua",
    "Amestoy",
    "Amézaga",
    "Ansolabehere",
    "Aramburo",
    "Aramburu",
    "Arana",
    "Arancibia",
    "Aráoz",
    "Araya",
    "Arce",
    "Archuleta",
    "Arguinzoniz",
    "Arguiñano",
    "Arismendi",
    "Armendáriz",
    "Aroca",
    "Arraiza",
    "Arrate",
    "Arrazola",
    "Arriaga",
    "Arrizabalaga",
    "Arrúa",
    "Arruabarrena",
    "Arruebarrena",
    "Arteaga",
    "Arteta",
    "Artiñano",
    "Arzate",
    "Astete",
    "Ayala",
    "Ayarza",
    "Aybar",
    "Azcárate",
    "Azcona",
    "Azócar",
    "Azpilicueta",
    "Azúa",
    "Azurmendi",
    "Balda",
    "Balenciaga",
    "Barea",
    "Barquín",
    "Barrueta",
    "Bazan",
    "Belaúnde",
    "Beloki",
    "Bengoetxea",
    "Beristain",
    "Buenechea",
    "Caínzos",
    "Camus",
    "Cano",
    "Caratachea",
    "Carranza",
    "Carrera",
    "Chasco",
    "Darrieussecq",
    "De Minaur",
    "De Miñaur",
    "Duhalde",
    "Echazú",
    "Echegaray",
    "Echenique",
    "Echeverría",
    "Eguren",
    "Eizaguirre",
    "Elcano",
    "Elissalde",
    "Elizalde",
    "Elizondo",
    "Elordi",
    "Elorriaga",
    "Elorza",
    "Esguerra",
    "Esparza",
    "Esquivel",
    "Estigarribia",
    "Etchegaray",
    "Etchemendy",
    "Etcheverry",
    "Etxaburu",
    "Etxaniz",
    "Etxeberria",
    "Eyzaguirre",
    "Gabarain",
    "Galarza",
    "Gallastegui",
    "Gamarra",
    "Gamboa",
    "Garai",
    "Garamendi",
    "Garay",
    "García",
    "Garibay",
    "Garicano",
    "Garitano",
    "Garmendia",
    "Garnica",
    "Garro",
    "Goicoechea",
    "Goitia",
    "Góngora",
    "Gorostiaga",
    "Gorostiza",
    "Goya",
    "Goyeneche",
    "Goyri",
    "Guevara",
    "Gurrola",
    "Gurrutxaga",
    "Hechavarría",
    "Heredia",
    "Higuaín",
    "Huicochea",
    "Ibarra",
    "Idiakez",
    "Iñárritu",
    "Inchausti",
    "Inciarte",
    "Iraheta",
    "Irala",
    "Iribarren",
    "Iribe",
    "Irigoyen",
    "Isasi",
    "Isaza",
    "Iturbi",
    "Iturbide",
    "Iturralde",
    "Iturri",
    "Iturria",
    "Izagirre",
    "Izaguirre",
    "Jáuregui",
    "Jiménez",
    "Juaristi",
    "Karanka",
    "Kortajarena",
    "Laharrague",
    "Landa",
    "Larraín",
    "Larralde",
    "Larrañaga",
    "Larreategui",
    "Lascano",
    "Laxalt",
    "Lazarte",
    "Legaspi",
    "Lejarreta",
    "Lizama",
    "Lizardi",
    "Lizárraga",
    "Lizarralde",
    "Loya",
    "Loynaz",
    "Loyola",
    "Madariaga",
    "Mahecha",
    "Mariátegui",
    "Mariñelarena",
    "Marriaga",
    "Mena",
    "Mendia",
    "Mendieta",
    "Mendive",
    "Mendizabal",
    "Mendoza",
    "Montoya",
    "Muguruza",
    "Mujica",
    "Muñoz",
    "Murua",
    "Narvaez",
    "Ochoa",
    "Olaizola",
    "Olaso",
    "Olazábal",
    "Oñate",
    "Oquendo",
    "Orjuela",
    "Ormaechea",
    "Ormazábal",
    "Orosco",
    "Orozco",
    "Oxandabarat",
    "Perurena",
    "Recalde",
    "Recarte",
    "Retegui",
    "Salazar",
    "Saldívar",
    "Saralegui",
    "Sarasola",
    "Solarte",
    "Trueba",
    "Ugalde",
    "Ugarte",
    "Ulacia",
    "Unzaga",
    "Uranga",
    "Urbina",
    "Urdinarán",
    "Uriarte",
    "Uribe",
    "Uriburu",
    "Urquía",
    "Urquidez",
    "Urquidi",
    "Urquijo",
    "Urrejola",
    "Urriola",
    "Urrutia",
    "Ursúa",
    "Urteaga",
    "Urtubey",
    "Usandizaga",
    "Useche",
    "Uzcátegui",
    "Velasco",
    "Velastegui",
    "Verano",
    "Vergara",
    "Videgain",
    "Vizcaíno",
    "Vizcarra",
    "Xavier",
    "Yarritu",
    "Ybáñez",
    "Ybarra",
    "Yñigo",
    "Zabala",
    "Zaldívar",
    "Zamacois",
    "Zamarripa",
    "Zambrano",
    "Zárate",
    "Zarazúa",
    "Zavala",
    "Zavaleta",
    "Zelaya",
    "Zornoza",
    "Zubeldia",
    "Zubiria",
    "Zubizarreta",
    "Zuloaga",
    "Zúñiga",
}

local Basque = CultureName.New({
    male = male,
    female = female,
    surname = surname,
    name = "Basque",
    code = "eu", -- ISO 639-1 code for Basque
    replace = {
        ['ñ'] = 'n', ['Ñ'] = 'N',
    }
})

return Basque
