-- Copyright © 2008-2025 Pioneer Developers. See AUTHORS.txt for details
-- Licensed under the terms of the GPL v3. See licenses/GPL-3.txt

-- Source surnames: https://parenting.firstcry.com/articles/60-hawaiian-last-names-or-surnames/
-- Source names: https://en.wiktionary.org/wiki/Appendix:Hawaiian_given_names
-- Source general info: https://nameberry.com/blog/hawaiian-names
-- Note: Hawaiian names are unisex even though some names are used predominantly for one of the sexes.
-- Many of the given names are therefore represented on both lists. Also, some are present on all the lists
-- since they are also used as surname.

local CultureName = require './common'

local male = {
	'Ahe',
	'Aʻiaʻi',
	'Analu',
	'Hali',
	'Healani',
	'Hoku',
	'Iwalani',
	'Kahanuola',
	'Kai',
	'Kaikane',
	'Kaimi',
	'Kaiea',
	'Kaiko',
	'Kaimana',
	'Kainona',
	'Kalani',
	'Kalei',
	'Kaleolani',
	'Kalino',
	'Kalua',
	'Kanai',
	'Kaniela',
	'Kanoa',
	'Kapueo',
	'Kau',
	'Kauai',
	'Kaʻuhane',
	'Kauʻionālani',
	'Kawena',
	'Kawai',
	'Kawika',
	'Keahilani',
	'Kealakekua',
	'Kealani',
	'Kealoha',
	'Keani',
	'Keanu',
	'Keikilani',
	'Keimoni',
	'Kekoa',
	'Kelani',
	'Keola',
	'Keone',
	'Keyon',
	'Khalei',
	'Kimo',
	'Kimokea',
	'Koa',
	'Koalani',
	'Konane',
	'Kulani',
	'Ky',
	'Lihau',
	'Lono',
	'Makai',
	'Makani',
	'Makoa',
	'Malulani',
	'Mana',
	'Maui',
	'Moani',
	'Momilani',
	'Nalu',
	'Nahele',
	'Nainoa',
	'Pika',
	'Pomaikai',
	'Pohaku',
	'Oke',
	'Wailani',
	'Wanaao',
}

local female = {
	'Ahe',
	'Aʻiaʻi',
	'Hali',
	'Hana',
	'Haunani',
	'Healani',
	'Hoku',
	'Iwalani',
	'Kahanuola',
	'Kai',
	'Kaimi',
	'Kaiea',
	'Kaiko',
	'Kaimana',
	'Kainona',
	'Kalani',
	'kalehua',
	'Kalei',
	'Kaleolani',
	'Kalua',
	'Kamea',
	'Kaniela',
	'Kapueo',
	'Kau',
	'Kauai',
	'Kaʻuhane',
	'Kauʻionālani',
	'Kawena',
	'Kawai',
	'Keahilani',
	'Kealakekua',
	'Kealani',
	'Kealoha',
	'Keani',
	'Keikilani',
	'Kelani',
	'Keone',
	'Khalei',
	'Kiana',
	'Kimokea',
	'Koalani',
	'Konane',
	'Kulani',
	'Kuʻuipo',
	'Ky',
	'Lana',
	'Lei',
	'Leinani',
	'Lihau',
	'Lilo', -- ;)
	'Lono',
	'Luana',
	'Makani',
	'Malia',
	'Malulani',
	'Mana',
	'Mele',
	'Moana',
	'Moani',
	'Momilani',
	'Nalu',
	'Nahele',
	'Nani',
	'Pika',
	'Pomaikai',
	'Pohaku',
	'Oke',
	'Wailani',
	'Wanaao',
}

local surname = {
	'Ailana',
	'Aka',
	'Akamai',
	'Akamu',
	'Akana',
	'Akina',
	'Alama',
	'Alana',
	'Alika',
	'Alohi',
	'Anela',
	'Aukai',
	'Ele',
	'Etana',
	'Eusebio',
	'Haku',
	'Hawea',
	'Hale',
	'Halia',
	'Haoa',
	'Haukea',
	'Havika',
	'Hekekia',
	'Hikialani',
	'Ikaika',
	'Illima',
	'Inoa',
	'Inoke',
	'Iokua',
	'Iona',
	'Ionakana',
	'Iosua',
	'Isaia',
	'Kaʻanaʻana',
	'Kaʻaukai',
	'Kahale',
	'Kahananui',
	'Kahele',
	'Kahie',
	'Kahue',
	'Kai',
	'Kainoa',
	'Kaiwi',
	'Kalama',
	'Kalani',
	'Kalawaiʻa',
	'Kalili',
	'Kalua',
	'Kama',
	'Kamealoha',
	'Kane',
	'Kapule',
	'Kaʻuhane',
	'Kawai',
	'Kawena',
	'Keahi',
	'Keaka',
	'Kealani',
	'Kealoha',
	'Keawe',
	'Kekoa',
	'Keliʻi',
	'Keona',
	'Konani',
	'Lani',
	'Lee',
	'Leilani',
	'Leimomi',
	'Leo',
	'Likeke',
	'Lilo',
	'Luda',
	'Lui',
	'Mahelona',
	'Mahoe',
	'Mahiʻai',
	'Makaio',
	'Makali',
	'Maliah',
	'Mana',
	'Manu',
	'Maui',
	'Mililani',
	'Moana',
	'Nainoa',
	'Nakamura',
	'Nani',
	'Noelani',
	'Okalani',
	'Olina',
	'Palakiko',
	'Palapala',
	'Pele',
	'Pelekai',
	'Peleke',
	'Pualani',
	'Ualoheke',
	'Urima',
	'Wailani',
}


local Hawaiian = CultureName.New(
{
	male = male,
	female = female,
	surname = surname,
	name = "Hawaiian",
	code = "haw",
	replace = {
		['ā'] = 'a', ['ʻ'] = '\'',  -- okina replaced by apostrophe
	}
})

return Hawaiian
