'use strict';

var protocolHttp = require('@smithy/protocol-http');

function addExpectContinueMiddleware(options) {
    return (next) => async (args) => {
        const { request } = args;
        if (options.expectContinueHeader !== false &&
            protocolHttp.HttpRequest.isInstance(request) &&
            request.body &&
            options.runtime === "node" &&
            options.requestHandler?.constructor?.name !== "FetchHttpHandler") {
            let sendHeader = true;
            if (typeof options.expectContinueHeader === "number") {
                try {
                    const bodyLength = Number(request.headers?.["content-length"]) ?? options.bodyLengthChecker?.(request.body) ?? Infinity;
                    sendHeader = bodyLength >= options.expectContinueHeader;
                }
                catch (e) { }
            }
            else {
                sendHeader = !!options.expectContinueHeader;
            }
            if (sendHeader) {
                request.headers.Expect = "100-continue";
            }
        }
        return next({
            ...args,
            request,
        });
    };
}
const addExpectContinueMiddlewareOptions = {
    step: "build",
    tags: ["SET_EXPECT_HEADER", "EXPECT_HEADER"],
    name: "addExpectContinueMiddleware",
    override: true,
};
const getAddExpectContinuePlugin = (options) => ({
    applyToStack: (clientStack) => {
        clientStack.add(addExpectContinueMiddleware(options), addExpectContinueMiddlewareOptions);
    },
});

exports.addExpectContinueMiddleware = addExpectContinueMiddleware;
exports.addExpectContinueMiddlewareOptions = addExpectContinueMiddlewareOptions;
exports.getAddExpectContinuePlugin = getAddExpectContinuePlugin;
