/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.international;

import edu.stanford.nlp.parser.lexparser.AbstractTreebankParserParams;
import edu.stanford.nlp.parser.lexparser.ArabicTreebankParserParams;
import edu.stanford.nlp.parser.lexparser.ChineseTreebankParserParams;
import edu.stanford.nlp.parser.lexparser.EnglishTreebankParserParams;
import edu.stanford.nlp.parser.lexparser.FrenchTreebankParserParams;
import edu.stanford.nlp.parser.lexparser.HebrewTreebankParserParams;
import edu.stanford.nlp.parser.lexparser.NegraPennTreebankParserParams;
import edu.stanford.nlp.parser.lexparser.TreebankLangParserParams;

public class Languages {
    private static final StringBuilder langList = new StringBuilder();

    private Languages() {
    }

    public static String listOfLanguages() {
        return langList.toString().trim();
    }

    public static TreebankLangParserParams getLanguageParams(String lang) {
        return Languages.getLanguageParams(Language.valueOf(lang));
    }

    public static TreebankLangParserParams getLanguageParams(Language lang) {
        AbstractTreebankParserParams tlpp;
        switch (lang) {
            case Arabic: {
                tlpp = new ArabicTreebankParserParams();
                break;
            }
            case Chinese: {
                tlpp = new ChineseTreebankParserParams();
                break;
            }
            case German: {
                tlpp = new NegraPennTreebankParserParams();
                break;
            }
            case French: {
                tlpp = new FrenchTreebankParserParams();
                break;
            }
            case Hebrew: {
                tlpp = new HebrewTreebankParserParams();
                break;
            }
            default: {
                tlpp = new EnglishTreebankParserParams();
            }
        }
        return tlpp;
    }

    static {
        for (Language lang : Language.values()) {
            langList.append(lang.toString());
            langList.append(" ");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Language {
        Arabic,
        Chinese,
        English,
        German,
        French,
        Hebrew;

    }
}

