/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.compare;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.configuration2.YAMLConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;

public class OpenApiDiffOptions {
    private final CompositeConfiguration config;

    private OpenApiDiffOptions(CompositeConfiguration config) {
        this.config = config;
    }

    public CompositeConfiguration getConfig() {
        return this.config;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private OpenApiDiffOptions built = new OpenApiDiffOptions(new CompositeConfiguration());

        public Builder configYaml(File file) {
            YAMLConfiguration yamlConfig = new YAMLConfiguration();
            try {
                yamlConfig.read(new FileReader(file));
            }
            catch (FileNotFoundException | ConfigurationException e) {
                throw new IllegalArgumentException("Problem loading config. file=" + file, e);
            }
            this.built.getConfig().addConfigurationFirst(yamlConfig);
            return this;
        }

        public Builder configProperty(String propKey, String propVal) {
            this.built.getConfig().setProperty(propKey, propVal);
            return this;
        }

        public OpenApiDiffOptions build() {
            return this.built;
        }
    }
}

