/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.model;

import java.io.IOException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.timeseries.TaskProfile;
import org.opensearch.timeseries.constant.CommonName;
import org.opensearch.timeseries.model.ConfigState;
import org.opensearch.timeseries.model.InitProgressProfile;
import org.opensearch.timeseries.model.Mergeable;
import org.opensearch.timeseries.model.ModelProfileOnNode;
import org.opensearch.timeseries.model.TimeSeriesTask;

public abstract class ConfigProfile<TaskClass extends TimeSeriesTask, TaskProfileType extends TaskProfile<TaskClass>>
implements Writeable,
ToXContentObject,
Mergeable {
    protected ConfigState state;
    protected String error;
    protected ModelProfileOnNode[] modelProfile;
    protected String coordinatingNode;
    protected long totalSizeInBytes;
    protected InitProgressProfile initProgress;
    protected Long totalEntities;
    protected Long activeEntities;
    protected TaskProfileType taskProfile;
    protected long modelCount;
    protected String taskName;

    public ConfigProfile(StreamInput in) throws IOException {
        if (in.readBoolean()) {
            this.state = (ConfigState)in.readEnum(ConfigState.class);
        }
        this.error = in.readOptionalString();
        this.modelProfile = (ModelProfileOnNode[])in.readOptionalArray(ModelProfileOnNode::new, ModelProfileOnNode[]::new);
        this.coordinatingNode = in.readOptionalString();
        this.totalSizeInBytes = in.readOptionalLong();
        this.totalEntities = in.readOptionalLong();
        this.activeEntities = in.readOptionalLong();
        if (in.readBoolean()) {
            this.initProgress = new InitProgressProfile(in);
        }
        if (in.readBoolean()) {
            this.taskProfile = this.createTaskProfile(in);
        }
        this.modelCount = in.readVLong();
    }

    protected ConfigProfile() {
    }

    public XContentBuilder toXContent(XContentBuilder builder) throws IOException {
        return this.toXContent(builder, ToXContent.EMPTY_PARAMS);
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (this.state == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeEnum((Enum)this.state);
        }
        out.writeOptionalString(this.error);
        out.writeOptionalArray((Writeable[])this.modelProfile);
        out.writeOptionalString(this.coordinatingNode);
        out.writeOptionalLong(Long.valueOf(this.totalSizeInBytes));
        out.writeOptionalLong(this.totalEntities);
        out.writeOptionalLong(this.activeEntities);
        if (this.initProgress == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.initProgress.writeTo(out);
        }
        if (this.taskProfile == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.taskProfile.writeTo(out);
        }
        out.writeVLong(this.modelCount);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentBuilder xContentBuilder = builder.startObject();
        if (this.state != null) {
            xContentBuilder.field("state", (Object)this.state);
        }
        if (this.error != null) {
            xContentBuilder.field("error", this.error);
        }
        if (this.modelProfile != null && this.modelProfile.length > 0) {
            xContentBuilder.startArray("models");
            for (ModelProfileOnNode profile : this.modelProfile) {
                profile.toXContent(xContentBuilder, params);
            }
            xContentBuilder.endArray();
        }
        if (this.coordinatingNode != null && !this.coordinatingNode.isEmpty()) {
            xContentBuilder.field("coordinating_node", this.coordinatingNode);
        }
        if (this.totalSizeInBytes != -1L) {
            xContentBuilder.field("total_size_in_bytes", this.totalSizeInBytes);
        }
        if (this.initProgress != null) {
            xContentBuilder.field("init_progress", (ToXContent)this.initProgress);
        }
        if (this.totalEntities != null) {
            xContentBuilder.field("total_entities", this.totalEntities);
        }
        if (this.activeEntities != null) {
            xContentBuilder.field("active_entities", this.activeEntities);
        }
        if (this.taskProfile != null) {
            xContentBuilder.field(this.getTaskFieldName(), this.taskProfile);
        }
        if (this.modelCount > 0L) {
            xContentBuilder.field(CommonName.MODEL_COUNT, this.modelCount);
        }
        return xContentBuilder.endObject();
    }

    public ConfigState getState() {
        return this.state;
    }

    public void setState(ConfigState state) {
        this.state = state;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public ModelProfileOnNode[] getModelProfile() {
        return this.modelProfile;
    }

    public void setModelProfile(ModelProfileOnNode[] modelProfile) {
        this.modelProfile = modelProfile;
    }

    public String getCoordinatingNode() {
        return this.coordinatingNode;
    }

    public void setCoordinatingNode(String coordinatingNode) {
        this.coordinatingNode = coordinatingNode;
    }

    public long getTotalSizeInBytes() {
        return this.totalSizeInBytes;
    }

    public void setTotalSizeInBytes(long totalSizeInBytes) {
        this.totalSizeInBytes = totalSizeInBytes;
    }

    public InitProgressProfile getInitProgress() {
        return this.initProgress;
    }

    public void setInitProgress(InitProgressProfile initProgress) {
        this.initProgress = initProgress;
    }

    public Long getTotalEntities() {
        return this.totalEntities;
    }

    public void setTotalEntities(Long totalEntities) {
        this.totalEntities = totalEntities;
    }

    public Long getActiveEntities() {
        return this.activeEntities;
    }

    public void setActiveEntities(Long activeEntities) {
        this.activeEntities = activeEntities;
    }

    public TaskProfileType getTaskProfile() {
        return this.taskProfile;
    }

    public void setTaskProfile(TaskProfileType taskProfile) {
        this.taskProfile = taskProfile;
    }

    public long getModelCount() {
        return this.modelCount;
    }

    public void setModelCount(long modelCount) {
        this.modelCount = modelCount;
    }

    @Override
    public void merge(Mergeable other) {
        if (this == other || other == null || this.getClass() != other.getClass()) {
            return;
        }
        ConfigProfile otherProfile = (ConfigProfile)other;
        if (otherProfile.getState() != null) {
            this.state = otherProfile.getState();
        }
        if (otherProfile.getError() != null) {
            this.error = otherProfile.getError();
        }
        if (otherProfile.getCoordinatingNode() != null) {
            this.coordinatingNode = otherProfile.getCoordinatingNode();
        }
        if (otherProfile.getModelProfile() != null) {
            this.modelProfile = otherProfile.getModelProfile();
        }
        if (otherProfile.getTotalSizeInBytes() != -1L) {
            this.totalSizeInBytes = otherProfile.getTotalSizeInBytes();
        }
        if (otherProfile.getInitProgress() != null) {
            this.initProgress = otherProfile.getInitProgress();
        }
        if (otherProfile.getTotalEntities() != null) {
            this.totalEntities = otherProfile.getTotalEntities();
        }
        if (otherProfile.getActiveEntities() != null) {
            this.activeEntities = otherProfile.getActiveEntities();
        }
        if (otherProfile.getTaskProfile() != null) {
            this.taskProfile = otherProfile.getTaskProfile();
        }
        if (otherProfile.getModelCount() > 0L) {
            this.modelCount = otherProfile.getModelCount();
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj instanceof ConfigProfile) {
            ConfigProfile other = (ConfigProfile)obj;
            EqualsBuilder equalsBuilder = new EqualsBuilder();
            if (this.state != null) {
                equalsBuilder.append((Object)this.state, (Object)other.state);
            }
            if (this.error != null) {
                equalsBuilder.append((Object)this.error, (Object)other.error);
            }
            if (this.modelProfile != null && this.modelProfile.length > 0) {
                equalsBuilder.append((Object[])this.modelProfile, (Object[])other.modelProfile);
            }
            if (this.coordinatingNode != null) {
                equalsBuilder.append((Object)this.coordinatingNode, (Object)other.coordinatingNode);
            }
            if (this.totalSizeInBytes != -1L) {
                equalsBuilder.append(this.totalSizeInBytes, other.totalSizeInBytes);
            }
            if (this.initProgress != null) {
                equalsBuilder.append((Object)this.initProgress, (Object)other.initProgress);
            }
            if (this.totalEntities != null) {
                equalsBuilder.append((Object)this.totalEntities, (Object)other.totalEntities);
            }
            if (this.activeEntities != null) {
                equalsBuilder.append((Object)this.activeEntities, (Object)other.activeEntities);
            }
            if (this.taskProfile != null) {
                equalsBuilder.append(this.taskProfile, other.taskProfile);
            }
            if (this.modelCount > 0L) {
                equalsBuilder.append(this.modelCount, other.modelCount);
            }
            return equalsBuilder.isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.state).append((Object)this.error).append((Object[])this.modelProfile).append((Object)this.coordinatingNode).append(this.totalSizeInBytes).append((Object)this.initProgress).append((Object)this.totalEntities).append((Object)this.activeEntities).append(this.taskProfile).append(this.modelCount).toHashCode();
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this);
        if (this.state != null) {
            toStringBuilder.append("state", (Object)this.state);
        }
        if (this.error != null) {
            toStringBuilder.append("error", (Object)this.error);
        }
        if (this.modelProfile != null && this.modelProfile.length > 0) {
            toStringBuilder.append((Object[])this.modelProfile);
        }
        if (this.coordinatingNode != null) {
            toStringBuilder.append("coordinating_node", (Object)this.coordinatingNode);
        }
        if (this.totalSizeInBytes != -1L) {
            toStringBuilder.append("total_size_in_bytes", this.totalSizeInBytes);
        }
        if (this.initProgress != null) {
            toStringBuilder.append("init_progress", (Object)this.initProgress);
        }
        if (this.totalEntities != null) {
            toStringBuilder.append("total_entities", (Object)this.totalEntities);
        }
        if (this.activeEntities != null) {
            toStringBuilder.append("active_entities", (Object)this.activeEntities);
        }
        if (this.taskProfile != null) {
            toStringBuilder.append(this.getTaskFieldName(), this.taskProfile);
        }
        if (this.modelCount > 0L) {
            toStringBuilder.append(CommonName.MODEL_COUNT, this.modelCount);
        }
        return toStringBuilder.toString();
    }

    protected abstract TaskProfileType createTaskProfile(StreamInput var1) throws IOException;

    protected abstract String getTaskFieldName();

    public static abstract class Builder<TaskClass extends TimeSeriesTask, TaskProfileType extends TaskProfile<TaskClass>> {
        protected ConfigState state = null;
        protected String error = null;
        protected ModelProfileOnNode[] modelProfile = null;
        protected String coordinatingNode = null;
        protected long totalSizeInBytes = -1L;
        protected InitProgressProfile initProgress = null;
        protected Long totalEntities;
        protected Long activeEntities;
        protected long modelCount = 0L;

        public Builder<TaskClass, TaskProfileType> state(ConfigState state) {
            this.state = state;
            return this;
        }

        public Builder<TaskClass, TaskProfileType> error(String error) {
            this.error = error;
            return this;
        }

        public Builder<TaskClass, TaskProfileType> modelProfile(ModelProfileOnNode[] modelProfile) {
            this.modelProfile = modelProfile;
            return this;
        }

        public Builder<TaskClass, TaskProfileType> modelCount(long modelCount) {
            this.modelCount = modelCount;
            return this;
        }

        public Builder<TaskClass, TaskProfileType> coordinatingNode(String coordinatingNode) {
            this.coordinatingNode = coordinatingNode;
            return this;
        }

        public Builder<TaskClass, TaskProfileType> totalSizeInBytes(long totalSizeInBytes) {
            this.totalSizeInBytes = totalSizeInBytes;
            return this;
        }

        public Builder<TaskClass, TaskProfileType> initProgress(InitProgressProfile initProgress) {
            this.initProgress = initProgress;
            return this;
        }

        public Builder<TaskClass, TaskProfileType> totalEntities(Long totalEntities) {
            this.totalEntities = totalEntities;
            return this;
        }

        public Builder<TaskClass, TaskProfileType> activeEntities(Long activeEntities) {
            this.activeEntities = activeEntities;
            return this;
        }

        public abstract Builder<TaskClass, TaskProfileType> taskProfile(TaskProfileType var1);

        public abstract <ConfigProfileType extends ConfigProfile<TaskClass, TaskProfileType>> ConfigProfileType build();
    }
}

