/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.s3express;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.auth.spi.signer.HttpSigner;
import software.amazon.awssdk.identity.spi.AwsCredentialsIdentity;
import software.amazon.awssdk.identity.spi.IdentityProvider;
import software.amazon.awssdk.identity.spi.IdentityProviders;
import software.amazon.awssdk.services.s3.internal.s3express.DefaultS3ExpressHttpSigner;
import software.amazon.awssdk.services.s3.internal.s3express.DefaultS3ExpressIdentityProvider;
import software.amazon.awssdk.services.s3.internal.s3express.S3ExpressIdentityCache;
import software.amazon.awssdk.services.s3.s3express.S3ExpressAuthScheme;
import software.amazon.awssdk.services.s3.s3express.S3ExpressSessionCredentials;

@SdkInternalApi
public final class DefaultS3ExpressAuthScheme
implements S3ExpressAuthScheme {
    private volatile S3ExpressIdentityCache cache;
    private final Object cacheLock = new Object();

    private DefaultS3ExpressAuthScheme() {
    }

    public static DefaultS3ExpressAuthScheme create() {
        return new DefaultS3ExpressAuthScheme();
    }

    public String schemeId() {
        return "aws.auth#sigv4-s3express";
    }

    @Override
    public IdentityProvider<S3ExpressSessionCredentials> identityProvider(IdentityProviders providers) {
        IdentityProvider baseIdentityProvider = providers.identityProvider(AwsCredentialsIdentity.class);
        if (baseIdentityProvider == null) {
            throw new IllegalStateException("Could not find a provider for AwsCredentialsIdentity");
        }
        return new DefaultS3ExpressIdentityProvider(this.getOrCreateCache(), (IdentityProvider<AwsCredentialsIdentity>)baseIdentityProvider);
    }

    @Override
    public HttpSigner<S3ExpressSessionCredentials> signer() {
        return DefaultS3ExpressHttpSigner.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private S3ExpressIdentityCache getOrCreateCache() {
        if (this.cache == null) {
            Object object = this.cacheLock;
            synchronized (object) {
                if (this.cache == null) {
                    this.cache = this.initCache();
                }
            }
        }
        return this.cache;
    }

    private S3ExpressIdentityCache initCache() {
        return S3ExpressIdentityCache.create();
    }
}

