/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.repositories.s3;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class GenericStatsMetricPublisher {
    private final AtomicLong normalPriorityQSize = new AtomicLong();
    private final AtomicInteger normalPriorityPermits = new AtomicInteger();
    private final AtomicLong lowPriorityQSize = new AtomicLong();
    private final AtomicInteger lowPriorityPermits = new AtomicInteger();
    private final long normalPriorityQCapacity;
    private final int maxNormalPriorityPermits;
    private final long lowPriorityQCapacity;
    private final int maxLowPriorityPermits;

    public GenericStatsMetricPublisher(long normalPriorityQCapacity, int maxNormalPriorityPermits, long lowPriorityQCapacity, int maxLowPriorityPermits) {
        this.normalPriorityQCapacity = normalPriorityQCapacity;
        this.maxNormalPriorityPermits = maxNormalPriorityPermits;
        this.lowPriorityQCapacity = lowPriorityQCapacity;
        this.maxLowPriorityPermits = maxLowPriorityPermits;
    }

    public void updateNormalPriorityQSize(long qSize) {
        this.normalPriorityQSize.addAndGet(qSize);
    }

    public void updateLowPriorityQSize(long qSize) {
        this.lowPriorityQSize.addAndGet(qSize);
    }

    public void updateNormalPermits(boolean increment) {
        if (increment) {
            this.normalPriorityPermits.incrementAndGet();
        } else {
            this.normalPriorityPermits.decrementAndGet();
        }
    }

    public void updateLowPermits(boolean increment) {
        if (increment) {
            this.lowPriorityPermits.incrementAndGet();
        } else {
            this.lowPriorityPermits.decrementAndGet();
        }
    }

    public long getNormalPriorityQSize() {
        return this.normalPriorityQSize.get();
    }

    public int getAcquiredNormalPriorityPermits() {
        return this.normalPriorityPermits.get();
    }

    public long getLowPriorityQSize() {
        return this.lowPriorityQSize.get();
    }

    public int getAcquiredLowPriorityPermits() {
        return this.lowPriorityPermits.get();
    }

    Map<String, Long> stats() {
        HashMap<String, Long> results = new HashMap<String, Long>();
        results.put("NormalPriorityQUtilization", this.normalPriorityQSize.get() * 100L / this.normalPriorityQCapacity);
        results.put("LowPriorityQUtilization", this.lowPriorityQSize.get() * 100L / this.lowPriorityQCapacity);
        results.put("NormalPriorityPermitsUtilization", (long)this.normalPriorityPermits.get() * 100L / (long)this.maxNormalPriorityPermits);
        results.put("LowPriorityPermitsUtilization", (long)this.lowPriorityPermits.get() * 100L / (long)this.maxLowPriorityPermits);
        return results;
    }
}

