/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rdr;

import com.tigervnc.rdr.Exception;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AESEAXCipher {
    private static final byte[] zeroBlock = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] prefixBlock0 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] prefixBlock1 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
    private static final byte[] prefixBlock2 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2};
    private static final int[] lut = new int[]{0, 135, 14, 137};
    private SecretKeySpec keySpec;
    private Cipher ctrCipher;
    private Cipher cbcCipher;
    private byte[] subKey1;
    private byte[] subKey2;

    public AESEAXCipher(byte[] byArray) {
        try {
            Cipher cipher = Cipher.getInstance("AES");
            this.cbcCipher = Cipher.getInstance("AES/CBC/NOPADDING");
            this.ctrCipher = Cipher.getInstance("AES/CTR/NOPADDING");
            this.keySpec = new SecretKeySpec(byArray, "AES");
            cipher.init(1, this.keySpec);
            this.cbcCipher.init(1, (Key)this.keySpec, new IvParameterSpec(zeroBlock));
            this.subKey1 = Arrays.copyOfRange(cipher.doFinal(zeroBlock), 0, 16);
            this.subKey2 = new byte[16];
            int n = (this.subKey1[0] & 0xFF) >>> 6;
            for (int i = 0; i < 15; ++i) {
                this.subKey2[i] = (byte)((this.subKey1[i + 1] & 0xFF) >>> 6 | (this.subKey1[i] & 0xFF) << 2);
                this.subKey1[i] = (byte)((this.subKey1[i + 1] & 0xFF) >>> 7 | (this.subKey1[i] & 0xFF) << 1);
            }
            this.subKey2[14] = (byte)(this.subKey2[14] ^ n >>> 1);
            this.subKey2[15] = (byte)((this.subKey1[15] & 0xFF) << 2 ^ lut[n]);
            this.subKey1[15] = (byte)((this.subKey1[15] & 0xFF) << 1 ^ lut[n >>> 1]);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException generalSecurityException) {
            throw new Exception("AESEAXCipher: AES algorithm is not supported");
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException generalSecurityException) {
            throw new Exception("AESEAXCipher: invalid key");
        }
    }

    private void encryptCTR(byte[] byArray, int n, int n2, byte[] byArray2, int n3, byte[] byArray3) {
        try {
            this.ctrCipher.init(1, (Key)this.keySpec, new IvParameterSpec(byArray3));
            this.ctrCipher.doFinal(byArray, n, n2, byArray2, n3);
        }
        catch (java.lang.Exception exception) {
            throw new Exception("AESEAXCipher: " + exception.toString());
        }
    }

    private byte[] computeCMAC(byte[] byArray, int n, int n2, byte[] byArray2) {
        int n3;
        int n4 = n2 / 16;
        int n5 = (n2 + 15) / 16;
        int n6 = n2 - n4 * 16;
        byte[] byArray3 = new byte[(n5 + 1) * 16];
        System.arraycopy(byArray2, 0, byArray3, 0, 16);
        System.arraycopy(byArray, n, byArray3, 16, n2);
        if (n6 == 0) {
            for (n3 = 0; n3 < 16; ++n3) {
                int n7 = n4 * 16 + n3;
                byArray3[n7] = (byte)(byArray3[n7] ^ this.subKey1[n3] & 0xFF);
            }
        } else {
            byArray3[(n4 + 1) * 16 + n6] = -128;
            for (n3 = 0; n3 < 16; ++n3) {
                int n8 = (n4 + 1) * 16 + n3;
                byArray3[n8] = (byte)(byArray3[n8] ^ this.subKey2[n3] & 0xFF);
            }
        }
        try {
            byte[] byArray4 = this.cbcCipher.doFinal(byArray3);
            return Arrays.copyOfRange(byArray4, byArray4.length - 16, byArray4.length - 0);
        }
        catch (java.lang.Exception exception) {
            throw new Exception("AESEAXCipher: " + exception.getMessage());
        }
    }

    public void encrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, byte[] byArray3, byte[] byArray4, int n5, byte[] byArray5, int n6) {
        byte[] byArray6 = this.computeCMAC(byArray3, 0, byArray3.length, prefixBlock0);
        this.encryptCTR(byArray, n, n2, byArray4, n5, byArray6);
        byte[] byArray7 = this.computeCMAC(byArray2, n3, n4, prefixBlock1);
        byte[] byArray8 = this.computeCMAC(byArray4, n5, n2, prefixBlock2);
        for (int i = 0; i < 16; ++i) {
            byArray5[n6 + i] = (byte)(byArray8[i] & 0xFF ^ byArray6[i] & 0xFF ^ byArray7[i] & 0xFF);
        }
    }

    public void decrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, byte[] byArray3, byte[] byArray4, int n5, byte[] byArray5, int n6) {
        byte[] byArray6 = this.computeCMAC(byArray3, 0, byArray3.length, prefixBlock0);
        byte[] byArray7 = this.computeCMAC(byArray2, n3, n4, prefixBlock1);
        byte[] byArray8 = this.computeCMAC(byArray, n, n2, prefixBlock2);
        for (int i = 0; i < 16; ++i) {
            byte by = (byte)(byArray8[i] & 0xFF ^ byArray6[i] & 0xFF ^ byArray7[i] & 0xFF);
            if (by == byArray5[n6 + i]) continue;
            throw new Exception("AESEAXCipher: failed to authenticate message");
        }
        this.encryptCTR(byArray, n, n2, byArray4, n5, byArray6);
    }
}

