﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/wellarchitected/WellArchitected_EXPORTS.h>
#include <aws/wellarchitected/model/PermissionType.h>
#include <aws/wellarchitected/model/ShareResourceType.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace WellArchitected {
namespace Model {

/**
 * <p>A share invitation summary return object.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ShareInvitationSummary">AWS
 * API Reference</a></p>
 */
class ShareInvitationSummary {
 public:
  AWS_WELLARCHITECTED_API ShareInvitationSummary() = default;
  AWS_WELLARCHITECTED_API ShareInvitationSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_WELLARCHITECTED_API ShareInvitationSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_WELLARCHITECTED_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The ID assigned to the share invitation.</p>
   */
  inline const Aws::String& GetShareInvitationId() const { return m_shareInvitationId; }
  inline bool ShareInvitationIdHasBeenSet() const { return m_shareInvitationIdHasBeenSet; }
  template <typename ShareInvitationIdT = Aws::String>
  void SetShareInvitationId(ShareInvitationIdT&& value) {
    m_shareInvitationIdHasBeenSet = true;
    m_shareInvitationId = std::forward<ShareInvitationIdT>(value);
  }
  template <typename ShareInvitationIdT = Aws::String>
  ShareInvitationSummary& WithShareInvitationId(ShareInvitationIdT&& value) {
    SetShareInvitationId(std::forward<ShareInvitationIdT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetSharedBy() const { return m_sharedBy; }
  inline bool SharedByHasBeenSet() const { return m_sharedByHasBeenSet; }
  template <typename SharedByT = Aws::String>
  void SetSharedBy(SharedByT&& value) {
    m_sharedByHasBeenSet = true;
    m_sharedBy = std::forward<SharedByT>(value);
  }
  template <typename SharedByT = Aws::String>
  ShareInvitationSummary& WithSharedBy(SharedByT&& value) {
    SetSharedBy(std::forward<SharedByT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetSharedWith() const { return m_sharedWith; }
  inline bool SharedWithHasBeenSet() const { return m_sharedWithHasBeenSet; }
  template <typename SharedWithT = Aws::String>
  void SetSharedWith(SharedWithT&& value) {
    m_sharedWithHasBeenSet = true;
    m_sharedWith = std::forward<SharedWithT>(value);
  }
  template <typename SharedWithT = Aws::String>
  ShareInvitationSummary& WithSharedWith(SharedWithT&& value) {
    SetSharedWith(std::forward<SharedWithT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline PermissionType GetPermissionType() const { return m_permissionType; }
  inline bool PermissionTypeHasBeenSet() const { return m_permissionTypeHasBeenSet; }
  inline void SetPermissionType(PermissionType value) {
    m_permissionTypeHasBeenSet = true;
    m_permissionType = value;
  }
  inline ShareInvitationSummary& WithPermissionType(PermissionType value) {
    SetPermissionType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The resource type of the share invitation.</p>
   */
  inline ShareResourceType GetShareResourceType() const { return m_shareResourceType; }
  inline bool ShareResourceTypeHasBeenSet() const { return m_shareResourceTypeHasBeenSet; }
  inline void SetShareResourceType(ShareResourceType value) {
    m_shareResourceTypeHasBeenSet = true;
    m_shareResourceType = value;
  }
  inline ShareInvitationSummary& WithShareResourceType(ShareResourceType value) {
    SetShareResourceType(value);
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetWorkloadName() const { return m_workloadName; }
  inline bool WorkloadNameHasBeenSet() const { return m_workloadNameHasBeenSet; }
  template <typename WorkloadNameT = Aws::String>
  void SetWorkloadName(WorkloadNameT&& value) {
    m_workloadNameHasBeenSet = true;
    m_workloadName = std::forward<WorkloadNameT>(value);
  }
  template <typename WorkloadNameT = Aws::String>
  ShareInvitationSummary& WithWorkloadName(WorkloadNameT&& value) {
    SetWorkloadName(std::forward<WorkloadNameT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetWorkloadId() const { return m_workloadId; }
  inline bool WorkloadIdHasBeenSet() const { return m_workloadIdHasBeenSet; }
  template <typename WorkloadIdT = Aws::String>
  void SetWorkloadId(WorkloadIdT&& value) {
    m_workloadIdHasBeenSet = true;
    m_workloadId = std::forward<WorkloadIdT>(value);
  }
  template <typename WorkloadIdT = Aws::String>
  ShareInvitationSummary& WithWorkloadId(WorkloadIdT&& value) {
    SetWorkloadId(std::forward<WorkloadIdT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetLensName() const { return m_lensName; }
  inline bool LensNameHasBeenSet() const { return m_lensNameHasBeenSet; }
  template <typename LensNameT = Aws::String>
  void SetLensName(LensNameT&& value) {
    m_lensNameHasBeenSet = true;
    m_lensName = std::forward<LensNameT>(value);
  }
  template <typename LensNameT = Aws::String>
  ShareInvitationSummary& WithLensName(LensNameT&& value) {
    SetLensName(std::forward<LensNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ARN for the lens.</p>
   */
  inline const Aws::String& GetLensArn() const { return m_lensArn; }
  inline bool LensArnHasBeenSet() const { return m_lensArnHasBeenSet; }
  template <typename LensArnT = Aws::String>
  void SetLensArn(LensArnT&& value) {
    m_lensArnHasBeenSet = true;
    m_lensArn = std::forward<LensArnT>(value);
  }
  template <typename LensArnT = Aws::String>
  ShareInvitationSummary& WithLensArn(LensArnT&& value) {
    SetLensArn(std::forward<LensArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The profile name.</p>
   */
  inline const Aws::String& GetProfileName() const { return m_profileName; }
  inline bool ProfileNameHasBeenSet() const { return m_profileNameHasBeenSet; }
  template <typename ProfileNameT = Aws::String>
  void SetProfileName(ProfileNameT&& value) {
    m_profileNameHasBeenSet = true;
    m_profileName = std::forward<ProfileNameT>(value);
  }
  template <typename ProfileNameT = Aws::String>
  ShareInvitationSummary& WithProfileName(ProfileNameT&& value) {
    SetProfileName(std::forward<ProfileNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The profile ARN.</p>
   */
  inline const Aws::String& GetProfileArn() const { return m_profileArn; }
  inline bool ProfileArnHasBeenSet() const { return m_profileArnHasBeenSet; }
  template <typename ProfileArnT = Aws::String>
  void SetProfileArn(ProfileArnT&& value) {
    m_profileArnHasBeenSet = true;
    m_profileArn = std::forward<ProfileArnT>(value);
  }
  template <typename ProfileArnT = Aws::String>
  ShareInvitationSummary& WithProfileArn(ProfileArnT&& value) {
    SetProfileArn(std::forward<ProfileArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the review template.</p>
   */
  inline const Aws::String& GetTemplateName() const { return m_templateName; }
  inline bool TemplateNameHasBeenSet() const { return m_templateNameHasBeenSet; }
  template <typename TemplateNameT = Aws::String>
  void SetTemplateName(TemplateNameT&& value) {
    m_templateNameHasBeenSet = true;
    m_templateName = std::forward<TemplateNameT>(value);
  }
  template <typename TemplateNameT = Aws::String>
  ShareInvitationSummary& WithTemplateName(TemplateNameT&& value) {
    SetTemplateName(std::forward<TemplateNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The review template ARN.</p>
   */
  inline const Aws::String& GetTemplateArn() const { return m_templateArn; }
  inline bool TemplateArnHasBeenSet() const { return m_templateArnHasBeenSet; }
  template <typename TemplateArnT = Aws::String>
  void SetTemplateArn(TemplateArnT&& value) {
    m_templateArnHasBeenSet = true;
    m_templateArn = std::forward<TemplateArnT>(value);
  }
  template <typename TemplateArnT = Aws::String>
  ShareInvitationSummary& WithTemplateArn(TemplateArnT&& value) {
    SetTemplateArn(std::forward<TemplateArnT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_shareInvitationId;
  bool m_shareInvitationIdHasBeenSet = false;

  Aws::String m_sharedBy;
  bool m_sharedByHasBeenSet = false;

  Aws::String m_sharedWith;
  bool m_sharedWithHasBeenSet = false;

  PermissionType m_permissionType{PermissionType::NOT_SET};
  bool m_permissionTypeHasBeenSet = false;

  ShareResourceType m_shareResourceType{ShareResourceType::NOT_SET};
  bool m_shareResourceTypeHasBeenSet = false;

  Aws::String m_workloadName;
  bool m_workloadNameHasBeenSet = false;

  Aws::String m_workloadId;
  bool m_workloadIdHasBeenSet = false;

  Aws::String m_lensName;
  bool m_lensNameHasBeenSet = false;

  Aws::String m_lensArn;
  bool m_lensArnHasBeenSet = false;

  Aws::String m_profileName;
  bool m_profileNameHasBeenSet = false;

  Aws::String m_profileArn;
  bool m_profileArnHasBeenSet = false;

  Aws::String m_templateName;
  bool m_templateNameHasBeenSet = false;

  Aws::String m_templateArn;
  bool m_templateArnHasBeenSet = false;
};

}  // namespace Model
}  // namespace WellArchitected
}  // namespace Aws
