﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/workspaces/WorkSpacesRequest.h>
#include <aws/workspaces/WorkSpaces_EXPORTS.h>

#include <utility>

namespace Aws {
namespace WorkSpaces {
namespace Model {

/**
 */
class AssociateIpGroupsRequest : public WorkSpacesRequest {
 public:
  AWS_WORKSPACES_API AssociateIpGroupsRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "AssociateIpGroups"; }

  AWS_WORKSPACES_API Aws::String SerializePayload() const override;

  AWS_WORKSPACES_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The identifier of the directory.</p>
   */
  inline const Aws::String& GetDirectoryId() const { return m_directoryId; }
  inline bool DirectoryIdHasBeenSet() const { return m_directoryIdHasBeenSet; }
  template <typename DirectoryIdT = Aws::String>
  void SetDirectoryId(DirectoryIdT&& value) {
    m_directoryIdHasBeenSet = true;
    m_directoryId = std::forward<DirectoryIdT>(value);
  }
  template <typename DirectoryIdT = Aws::String>
  AssociateIpGroupsRequest& WithDirectoryId(DirectoryIdT&& value) {
    SetDirectoryId(std::forward<DirectoryIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The identifiers of one or more IP access control groups.</p>
   */
  inline const Aws::Vector<Aws::String>& GetGroupIds() const { return m_groupIds; }
  inline bool GroupIdsHasBeenSet() const { return m_groupIdsHasBeenSet; }
  template <typename GroupIdsT = Aws::Vector<Aws::String>>
  void SetGroupIds(GroupIdsT&& value) {
    m_groupIdsHasBeenSet = true;
    m_groupIds = std::forward<GroupIdsT>(value);
  }
  template <typename GroupIdsT = Aws::Vector<Aws::String>>
  AssociateIpGroupsRequest& WithGroupIds(GroupIdsT&& value) {
    SetGroupIds(std::forward<GroupIdsT>(value));
    return *this;
  }
  template <typename GroupIdsT = Aws::String>
  AssociateIpGroupsRequest& AddGroupIds(GroupIdsT&& value) {
    m_groupIdsHasBeenSet = true;
    m_groupIds.emplace_back(std::forward<GroupIdsT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_directoryId;

  Aws::Vector<Aws::String> m_groupIds;
  bool m_directoryIdHasBeenSet = false;
  bool m_groupIdsHasBeenSet = false;
};

}  // namespace Model
}  // namespace WorkSpaces
}  // namespace Aws
