/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.altibase.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBDatabaseException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.altibase.AltibaseConstants;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseDataSource;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseGrantee;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseTablespace;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.LazyProperty;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class AltibaseUser
extends AltibaseGrantee {
    private Timestamp lockDate;
    private Timestamp passwordexpiryDate;
    private int passwordGraceTime;
    private Object defaultTablespace;
    private Object tempTablespace;
    private Object profile;
    private Timestamp createDate;
    private ArrayList<AltibaseTablespace> userTbsList = null;
    private boolean isSysUser = false;

    public AltibaseUser(AltibaseDataSource dataSource, JDBCResultSet resultSet) {
        super(dataSource, JDBCUtils.safeGetString((ResultSet)resultSet, (String)"USER_NAME"));
        this.name = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"USER_NAME");
        this.lockDate = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"ACCOUNT_LOCK_DATE");
        this.passwordexpiryDate = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"PASSWORD_EXPIRY_DATE");
        this.passwordGraceTime = JDBCUtils.safeGetInt((ResultSet)resultSet, (String)"PASSWORD_GRACE_TIME");
        this.defaultTablespace = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"DEFAULT_TBS_NAME");
        this.tempTablespace = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"TEMP_TBS_NAME");
        this.createDate = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"CREATED");
        this.isSysUser = AltibaseConstants.isSysUser(this.name);
    }

    @Property(viewable=true, order=2)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=5)
    @LazyProperty(cacheValidator=AltibaseTablespace.TablespaceReferenceValidator.class)
    public Object getDefaultTablespace(DBRProgressMonitor monitor) throws DBException {
        return AltibaseTablespace.resolveTablespaceReference(monitor, this, "defaultTablespace");
    }

    @Property(viewable=true, order=6)
    @LazyProperty(cacheValidator=AltibaseTablespace.TablespaceReferenceValidator.class)
    public Object getTempTablespace(DBRProgressMonitor monitor) throws DBException {
        return AltibaseTablespace.resolveTablespaceReference(monitor, this, "tempTablespace");
    }

    @Property(viewable=true, order=9)
    public Timestamp getLockDate() {
        return this.lockDate;
    }

    @Property(viewable=true, order=10)
    public Timestamp getPasswordexpiryDate() {
        return this.passwordexpiryDate;
    }

    @Property(viewable=true, order=11)
    public int getPasswordGraceTime() {
        return this.passwordGraceTime;
    }

    @Property(viewable=true, order=15)
    public Timestamp getCreateDate() {
        return this.createDate;
    }

    @Nullable
    public Object getLazyReference(Object propertyId) {
        if ("defaultTablespace".equals(propertyId)) {
            return this.defaultTablespace;
        }
        if ("tempTablespace".equals(propertyId)) {
            return this.tempTablespace;
        }
        if ("profile".equals(propertyId)) {
            return this.profile;
        }
        return null;
    }

    @Override
    @Nullable
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.refreshObject(monitor);
        this.userTbsList = null;
        return this;
    }

    public Collection<AltibaseTablespace> getTablespaces(DBRProgressMonitor monitor) throws DBException {
        block25: {
            this.userTbsList = new ArrayList();
            Map<String, AltibaseTablespace> dbTbsMap = this.getDataSource().getTablespaces(monitor).stream().collect(Collectors.toMap(AltibaseTablespace::getName, AltibaseTablespace2 -> AltibaseTablespace2));
            String tbsName = null;
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this.getParentObject(), (String)"Load tablespaces for user");){
                    Throwable throwable2 = null;
                    Object var8_12 = null;
                    try (JDBCStatement dbStat = this.prepareTablespaceName4UserLoadStatement(session, this);){
                        dbStat.setFetchSize(1000);
                        dbStat.executeStatement();
                        JDBCResultSet dbResult = dbStat.getResultSet();
                        if (dbResult == null) break block25;
                        try {
                            while (dbResult.next()) {
                                if (monitor.isCanceled()) {
                                    break;
                                }
                                tbsName = dbResult.getString(1);
                                if (!dbTbsMap.containsKey(tbsName)) continue;
                                this.userTbsList.add(dbTbsMap.get(tbsName));
                            }
                        }
                        finally {
                            dbResult.close();
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBDatabaseException((Throwable)e, (DBPDataSource)this.getDataSource());
            }
        }
        return this.userTbsList;
    }

    public JDBCStatement prepareTablespaceName4UserLoadStatement(JDBCSession session, AltibaseUser user) throws SQLException {
        String qry = this.isSysUser ? "SELECT t.name FROM  v$tablespaces t ORDER BY 1" : "SELECT t.name FROM  v$tablespaces t, system_.sys_users_ u WHERE u.user_name = ? AND (u.default_tbs_id = t.id OR u.temp_tbs_id  = t.id) UNION ALL SELECT t.name FROM system_.sys_tbs_users_ tu, v$tablespaces t, system_.sys_users_ u WHERE u.user_name = ? AND u.user_id = tu.user_id AND tu.tbs_id = t.id AND tu.is_access = 1 ORDER BY 1 ASC";
        JDBCPreparedStatement dbStat = session.prepareStatement(qry);
        if (!this.isSysUser) {
            dbStat.setString(1, user.getName());
            dbStat.setString(2, user.getName());
        }
        return dbStat;
    }
}

