/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.model;

import java.sql.Connection;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.ext.exasol.model.ExasolSchema;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionBootstrap;
import org.jkiss.dbeaver.model.exec.DBCCachedContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCFeatureNotSupportedException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCRemoteInstance;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.utils.CommonUtils;

public class ExasolExecutionContext
extends JDBCExecutionContext
implements DBCExecutionContextDefaults<DBSCatalog, ExasolSchema> {
    private static final Log log = Log.getLog(ExasolExecutionContext.class);
    private static final String GET_CURRENT_SCHEMA = "/*snapshot execution*/ SELECT CURRENT_SCHEMA";
    private static final String SET_CURRENT_SCHEMA = "OPEN SCHEMA \"%s\"";
    private String activeSchemaName;

    ExasolExecutionContext(@NotNull JDBCRemoteInstance instance, String purpose) {
        super(instance, purpose);
    }

    @NotNull
    public ExasolDataSource getDataSource() {
        return (ExasolDataSource)super.getDataSource();
    }

    @NotNull
    public ExasolExecutionContext getContextDefaults() {
        return this;
    }

    public String getActiveSchemaName() {
        return this.activeSchemaName;
    }

    public DBSCatalog getDefaultCatalog() {
        return null;
    }

    public ExasolSchema getDefaultSchema() {
        return this.activeSchemaName == null ? null : (ExasolSchema)this.getDataSource().getSchemaCache().getCachedObject(this.activeSchemaName);
    }

    public boolean supportsCatalogChange() {
        return false;
    }

    public boolean supportsSchemaChange() {
        return true;
    }

    public void setDefaultCatalog(DBRProgressMonitor monitor, DBSCatalog catalog, ExasolSchema schema) throws DBCException {
        throw new DBCFeatureNotSupportedException();
    }

    public void setDefaultSchema(DBRProgressMonitor monitor, ExasolSchema schema) throws DBCException {
        ExasolSchema oldSelectedEntity = this.getDefaultSchema();
        if (schema == null || oldSelectedEntity == schema) {
            return;
        }
        this.setCurrentSchema(monitor, schema);
        this.activeSchemaName = schema.getName();
        DBUtils.fireObjectSelectionChange((DBSObject)oldSelectedEntity, (DBSObject)schema, (DBCExecutionContext)this);
    }

    public boolean refreshDefaults(DBRProgressMonitor monitor, boolean useBootstrapSettings) throws DBException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (JDBCSession session = this.openSession(monitor, DBCExecutionPurpose.META, "Query active schema");){
                DBPConnectionBootstrap bootstrap;
                if (useBootstrapSettings && !CommonUtils.isEmpty((String)(bootstrap = this.getBootstrapSettings()).getDefaultSchemaName())) {
                    this.setCurrentSchema(monitor, bootstrap.getDefaultSchemaName());
                }
                this.activeSchemaName = this.determineActiveSchema(session);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new DBCException((Throwable)e, (DBCExecutionContext)this);
        }
        return true;
    }

    void setCurrentSchema(DBRProgressMonitor monitor, ExasolSchema object) throws DBCException {
        if (object == null) {
            log.debug((Object)"Null current schema");
            return;
        }
        this.setCurrentSchema(monitor, object.getName());
    }

    private void setCurrentSchema(DBRProgressMonitor monitor, String schemaName) throws DBCException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (JDBCSession session = this.openSession(monitor, DBCExecutionPurpose.UTIL, "Set active schema");){
                JDBCUtils.executeSQL((Connection)session, (String)String.format(SET_CURRENT_SCHEMA, schemaName), (Object[])new Object[0]);
                this.activeSchemaName = schemaName;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBCException((Throwable)e, (DBCExecutionContext)this);
        }
    }

    private String determineActiveSchema(JDBCSession session) throws SQLException {
        String defSchema = JDBCUtils.queryString((Connection)session, (String)GET_CURRENT_SCHEMA, (Object[])new Object[0]);
        if (defSchema == null) {
            return null;
        }
        return defSchema.trim();
    }

    @NotNull
    public DBCCachedContextDefaults getCachedDefault() {
        return new DBCCachedContextDefaults(null, this.activeSchemaName);
    }
}

