/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.ui.editors;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.dbeaver.ext.postgresql.PostgreMessages;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreJobStep;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedure;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreScriptObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTriggerBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreViewBase;
import org.jkiss.dbeaver.ext.postgresql.ui.editors.sql.handlers.SQLEditorHandlerCheckProcedureConsole;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.generator.SQLGenerator;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedure;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLSourceViewer;
import org.jkiss.dbeaver.ui.editors.sql.handlers.SQLEditorHandlerOpenObjectConsole;
import org.jkiss.dbeaver.ui.editors.sql.handlers.SQLNavigatorContext;
import org.jkiss.utils.CommonUtils;

public class PostgreSourceViewEditor
extends SQLSourceViewer<PostgreScriptObject> {
    protected boolean isReadOnly() {
        PostgreScriptObject sourceObject = (PostgreScriptObject)this.getSourceObject();
        return !(sourceObject instanceof PostgreProcedure) && !(sourceObject instanceof PostgreTriggerBase) && !(sourceObject instanceof PostgreViewBase) && !(sourceObject instanceof PostgreJobStep);
    }

    protected boolean isAnnotationRulerVisible() {
        return this.getSourceObject() instanceof PostgreProcedure;
    }

    protected void setSourceText(DBRProgressMonitor monitor, String sourceText) {
        this.getInputPropertySource().setPropertyValue(monitor, "objectDefinitionText", (Object)sourceText);
    }

    protected void contributeEditorCommands(IContributionManager contributionManager) {
        super.contributeEditorCommands(contributionManager);
        final PostgreScriptObject sourceObject = (PostgreScriptObject)this.getSourceObject();
        if (sourceObject instanceof PostgreProcedure) {
            contributionManager.add((IContributionItem)new Separator());
            contributionManager.add((IContributionItem)ActionUtils.makeActionContribution((IAction)new Action(PostgreMessages.source_view_show_header_label, 2){
                {
                    this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)DBIcon.TREE_PROCEDURE));
                    this.setToolTipText(PostgreMessages.source_view_show_header_description);
                    this.setChecked(!PostgreSourceViewEditor.this.isInDebugMode());
                }

                public void run() {
                    PostgreSourceViewEditor.this.getDatabaseEditorInput().setAttribute("debugger.source", (Object)(!this.isChecked() ? 1 : 0));
                    PostgreSourceViewEditor.this.refreshPart((Object)PostgreSourceViewEditor.this, true);
                }
            }, (boolean)true));
            contributionManager.add((IContributionItem)ActionUtils.makeActionContribution((IAction)new Action(PostgreMessages.procedure_check_label, 1){
                {
                    super($anonymous0, $anonymous1);
                    this.setToolTipText(PostgreMessages.procedure_check_description);
                }

                public void run() {
                    IWorkbenchWindow workbenchWindow = UIUtils.getActiveWorkbenchWindow();
                    ArrayList<DBSProcedure> entities = new ArrayList<DBSProcedure>();
                    entities.add((DBSProcedure)sourceObject);
                    SQLGenerator<DBSProcedure> generator = SQLEditorHandlerCheckProcedureConsole.checkGenerator(entities);
                    UIUtils.runInUI((IRunnableContext)workbenchWindow, generator);
                    String sql = CommonUtils.notEmpty((String)((String)generator.getResult()));
                    SQLNavigatorContext navContext = new SQLNavigatorContext((DBSObject)sourceObject);
                    String procName = ((DBSProcedure)sourceObject).getName();
                    String title = NLS.bind((String)PostgreMessages.procedure_check_label2, (Object)procName);
                    try {
                        SQLEditorHandlerOpenObjectConsole.openAndExecuteSQLScript((IWorkbenchWindow)workbenchWindow, (SQLNavigatorContext)navContext, (String)title, (boolean)true, null, (String)sql, (boolean)true);
                    }
                    catch (CoreException e) {
                        DBWorkbench.getPlatformUI().showError(PostgreMessages.message_open_console, PostgreMessages.error_cant_open_sql_editor, (Throwable)e);
                    }
                }
            }, (boolean)true));
        }
    }

    protected Map<String, Object> getSourceOptions() {
        Map options = super.getSourceOptions();
        options.put("debugger.source", this.isInDebugMode());
        return options;
    }

    private boolean isInDebugMode() {
        return CommonUtils.getBoolean((Object)this.getDatabaseEditorInput().getAttribute("debugger.source"), (boolean)false);
    }
}

