/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.admin;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.jcs3.access.exception.CacheException;
import org.apache.commons.jcs3.admin.CacheElementInfo;
import org.apache.commons.jcs3.admin.CacheRegionInfo;
import org.apache.commons.jcs3.admin.CountingOnlyOutputStream;
import org.apache.commons.jcs3.admin.JCSJMXBean;
import org.apache.commons.jcs3.auxiliary.remote.server.RemoteCacheServer;
import org.apache.commons.jcs3.auxiliary.remote.server.RemoteCacheServerFactory;
import org.apache.commons.jcs3.engine.CacheElementSerialized;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.engine.behavior.IElementAttributes;
import org.apache.commons.jcs3.engine.control.CompositeCache;
import org.apache.commons.jcs3.engine.control.CompositeCacheManager;
import org.apache.commons.jcs3.engine.memory.behavior.IMemoryCache;

public class JCSAdminBean
implements JCSJMXBean {
    private final CompositeCacheManager cacheHub;

    public JCSAdminBean() {
        try {
            this.cacheHub = CompositeCacheManager.getInstance();
        }
        catch (CacheException e) {
            throw new RuntimeException("Could not retrieve cache manager instance", e);
        }
    }

    public JCSAdminBean(CompositeCacheManager cacheHub) {
        this.cacheHub = cacheHub;
    }

    @Override
    public List<CacheElementInfo> buildElementInfo(String cacheName) throws IOException {
        CompositeCache cache = this.cacheHub.getCache(cacheName);
        TreeMap<String, Object> keys = new TreeMap<String, Object>(cache.getMemoryCache().getKeySet().stream().collect(Collectors.toMap(Object::toString, k -> k)));
        LinkedList<CacheElementInfo> records = new LinkedList<CacheElementInfo>();
        DateFormat format = DateFormat.getDateTimeInstance(3, 3);
        long now = System.currentTimeMillis();
        for (Map.Entry<String, Object> key : keys.entrySet()) {
            ICacheElement element = cache.getMemoryCache().getQuiet(key.getValue());
            IElementAttributes attributes = element.getElementAttributes();
            CacheElementInfo elementInfo = new CacheElementInfo(key.getKey(), attributes.getIsEternal(), format.format(new Date(attributes.getCreateTime())), attributes.getMaxLife(), (now - attributes.getCreateTime() - attributes.getMaxLife() * 1000L) / -1000L);
            records.add(elementInfo);
        }
        return records;
    }

    @Override
    public List<CacheRegionInfo> buildCacheInfo() {
        TreeSet<String> cacheNames = new TreeSet<String>(this.cacheHub.getCacheNames());
        LinkedList<CacheRegionInfo> cacheInfo = new LinkedList<CacheRegionInfo>();
        for (String cacheName : cacheNames) {
            CompositeCache cache = this.cacheHub.getCache(cacheName);
            CacheRegionInfo regionInfo = new CacheRegionInfo(cache.getCacheName(), cache.getSize(), cache.getStatus().toString(), cache.getStats(), cache.getHitCountRam(), cache.getHitCountAux(), cache.getMissCountNotFound(), cache.getMissCountExpired(), this.getByteCount(cache));
            cacheInfo.add(regionInfo);
        }
        return cacheInfo;
    }

    @Override
    public long getByteCount(String cacheName) {
        return this.getByteCount(this.cacheHub.getCache(cacheName));
    }

    public <K, V> long getByteCount(CompositeCache<K, V> cache) {
        if (cache == null) {
            throw new IllegalArgumentException("The cache object specified was null.");
        }
        long size = 0L;
        IMemoryCache<K, V> memCache = cache.getMemoryCache();
        for (K key : memCache.getKeySet()) {
            ICacheElement<K, V> ice = null;
            try {
                ice = memCache.get(key);
            }
            catch (IOException e) {
                throw new RuntimeException("IOException while trying to get a cached element", e);
            }
            if (ice == null) continue;
            if (ice instanceof CacheElementSerialized) {
                size += (long)((CacheElementSerialized)ice).getSerializedValue().length;
                continue;
            }
            V element = ice.getVal();
            CountingOnlyOutputStream counter = new CountingOnlyOutputStream();
            try (ObjectOutputStream out = new ObjectOutputStream(counter);){
                out.writeObject(element);
            }
            catch (IOException e) {
                throw new RuntimeException("IOException while trying to measure the size of the cached element", e);
            }
            finally {
                try {
                    counter.close();
                }
                catch (IOException iOException) {}
            }
            size += (long)(counter.getCount() - 4);
        }
        return size;
    }

    @Override
    public void clearAllRegions() throws IOException {
        RemoteCacheServer remoteCacheServer = RemoteCacheServerFactory.getRemoteCacheServer();
        if (remoteCacheServer == null) {
            for (String name : this.cacheHub.getCacheNames()) {
                this.cacheHub.getCache(name).removeAll();
            }
        } else {
            for (String name : this.cacheHub.getCacheNames()) {
                remoteCacheServer.removeAll(name);
            }
        }
    }

    @Override
    public void clearRegion(String cacheName) throws IOException {
        if (cacheName == null) {
            throw new IllegalArgumentException("The cache name specified was null.");
        }
        if (RemoteCacheServerFactory.getRemoteCacheServer() == null) {
            this.cacheHub.getCache(cacheName).removeAll();
        } else {
            try {
                RemoteCacheServer remoteCacheServer = RemoteCacheServerFactory.getRemoteCacheServer();
                remoteCacheServer.removeAll(cacheName);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to remove all elements from cache region [" + cacheName + "]: " + e, e);
            }
        }
    }

    @Override
    public void removeItem(String cacheName, String key) throws IOException {
        if (cacheName == null) {
            throw new IllegalArgumentException("The cache name specified was null.");
        }
        if (key == null) {
            throw new IllegalArgumentException("The key specified was null.");
        }
        if (RemoteCacheServerFactory.getRemoteCacheServer() == null) {
            this.cacheHub.getCache(cacheName).remove(key);
        } else {
            try {
                Object keyToRemove = null;
                CompositeCache cache = CompositeCacheManager.getInstance().getCache(cacheName);
                Set allKeysInCache = cache.getMemoryCache().getKeySet();
                for (Object keyInCache : allKeysInCache) {
                    if (!keyInCache.toString().equals(key)) continue;
                    if (keyToRemove != null) {
                        throw new IllegalStateException("Unexpectedly found duplicate keys in the cache region matching the key specified.");
                    }
                    keyToRemove = keyInCache;
                }
                if (keyToRemove == null) {
                    throw new IllegalStateException("No match for this key could be found in the set of keys retrieved from the memory cache.");
                }
                RemoteCacheServer remoteCacheServer = RemoteCacheServerFactory.getRemoteCacheServer();
                remoteCacheServer.remove(cacheName, key);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to remove element with key [" + key + ", " + key.getClass() + "] from cache region [" + cacheName + "]: " + e, e);
            }
        }
    }
}

