/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.expression;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.query.sqm.tree.expression.NumericTypeCategory;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.spi.TypeConfiguration;

public class UnparsedNumericLiteral<N extends Number>
implements Literal,
DomainResultProducer<N> {
    private final String literalValue;
    private final NumericTypeCategory typeCategory;
    private final JdbcMapping jdbcMapping;

    public UnparsedNumericLiteral(String literalValue, NumericTypeCategory typeCategory, JdbcMapping jdbcMapping) {
        this.literalValue = literalValue;
        this.typeCategory = typeCategory;
        this.jdbcMapping = jdbcMapping;
    }

    public N getLiteralValue() {
        return this.typeCategory.parseLiteralValue(this.literalValue);
    }

    @Override
    public void bindParameterValue(PreparedStatement statement, int startPosition, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) throws SQLException {
        this.jdbcMapping.getJdbcValueBinder().bind(statement, this.getLiteralValue(), startPosition, (WrapperOptions)executionContext.getSession());
    }

    public String getUnparsedLiteralValue() {
        return this.literalValue;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.jdbcMapping;
    }

    @Override
    public JdbcMappingContainer getExpressionType() {
        return this.getJdbcMapping();
    }

    @Override
    public DomainResult<N> createDomainResult(String resultVariable, DomainResultCreationState creationState) {
        SqlExpressionResolver sqlExpressionResolver = creationState.getSqlAstCreationState().getSqlExpressionResolver();
        TypeConfiguration typeConfiguration = creationState.getSqlAstCreationState().getCreationContext().getTypeConfiguration();
        SqlSelection sqlSelection = sqlExpressionResolver.resolveSqlSelection(this, this.getJdbcMapping().getJdbcJavaType(), null, typeConfiguration);
        return new BasicResult(sqlSelection.getValuesArrayPosition(), resultVariable, this.jdbcMapping);
    }

    @Override
    public void applySqlSelections(DomainResultCreationState creationState) {
        creationState.getSqlAstCreationState().getSqlExpressionResolver().resolveSqlSelection(this, this.jdbcMapping.getJdbcJavaType(), null, creationState.getSqlAstCreationState().getCreationContext().getMappingMetamodel().getTypeConfiguration());
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        sqlTreeWalker.visitUnparsedNumericLiteral(this);
    }
}

