/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.km.jvm;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.km.jvm.JvmMemberSignature;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JvmMethodSignature
extends JvmMemberSignature {
    @NotNull
    private final String name;
    @NotNull
    private final String descriptor;

    public JvmMethodSignature(@NotNull String name, @NotNull String descriptor2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        super(null);
        this.name = name;
        this.descriptor = descriptor2;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getDescriptor() {
        return this.descriptor;
    }

    @Override
    @NotNull
    public String toString() {
        return this.getName() + this.getDescriptor();
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + this.descriptor.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JvmMethodSignature)) {
            return false;
        }
        JvmMethodSignature jvmMethodSignature = (JvmMethodSignature)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)jvmMethodSignature.name)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.descriptor, (Object)jvmMethodSignature.descriptor);
    }
}

