/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.java.JavaSystem;

public class FileUtil
implements FileAccess {
    private static FileUtil fileUtil = new FileUtil();
    public final boolean fsIsIgnoreCase = new File("A").equals(new File("a"));
    public final boolean fsNormalizesPosixSeparator = new File("/").getPath().endsWith(File.separator);
    final Random random = new Random(System.currentTimeMillis());

    FileUtil() {
    }

    public static FileUtil getDefaultInstance() {
        return fileUtil;
    }

    @Override
    public boolean isStreamElement(String string) {
        return new File(string).exists();
    }

    @Override
    public InputStream openInputStreamElement(String string) throws IOException {
        try {
            return new FileInputStream(new File(string));
        }
        catch (Throwable throwable) {
            throw FileUtil.toIOException(throwable);
        }
    }

    @Override
    public void createParentDirs(String string) {
        this.makeParentDirectories(new File(string));
    }

    @Override
    public void removeElement(String string) {
        if (this.isStreamElement(string)) {
            this.delete(string);
        }
    }

    @Override
    public void renameElement(String string, String string2) {
        this.renameOverwrite(string, string2);
    }

    @Override
    public OutputStream openOutputStreamElement(String string) throws IOException {
        return new FileOutputStream(new File(string));
    }

    public void delete(String string) {
        new File(string).delete();
    }

    public void deleteOnExit(File file) {
        JavaSystem.deleteOnExit(file);
    }

    public boolean exists(String string) {
        return new File(string).exists();
    }

    public boolean exists(String string, boolean bl, Class clazz) {
        if (string == null || string.length() == 0) {
            return false;
        }
        return bl ? null != clazz.getResource(string) : FileUtil.getDefaultInstance().exists(string);
    }

    private void renameOverwrite(String string, String string2) {
        this.delete(string2);
        if (this.exists(string)) {
            File file = new File(string);
            file.renameTo(new File(string2));
        }
    }

    public static IOException toIOException(Throwable throwable) {
        if (throwable instanceof IOException) {
            return (IOException)throwable;
        }
        return new IOException(throwable.toString());
    }

    public String absolutePath(String string) {
        return new File(string).getAbsolutePath();
    }

    public File canonicalFile(File file) throws IOException {
        return new File(file.getCanonicalPath());
    }

    public File canonicalFile(String string) throws IOException {
        return new File(new File(string).getCanonicalPath());
    }

    public String canonicalPath(File file) throws IOException {
        return file.getCanonicalPath();
    }

    public String canonicalPath(String string) throws IOException {
        return new File(string).getCanonicalPath();
    }

    public String canonicalOrAbsolutePath(String string) {
        try {
            return this.canonicalPath(string);
        }
        catch (Exception exception) {
            return this.absolutePath(string);
        }
    }

    public void makeParentDirectories(File file) {
        String string = file.getParent();
        if (string != null) {
            new File(string).mkdirs();
        } else {
            string = file.getPath();
            int n = string.lastIndexOf(47);
            if (n > 0) {
                string = string.substring(0, n);
                new File(string).mkdirs();
            }
        }
    }

    @Override
    public FileAccess.FileSync getFileSync(OutputStream outputStream) throws IOException {
        return new FileSync((FileOutputStream)outputStream);
    }

    public class FileSync
    implements FileAccess.FileSync {
        FileDescriptor outDescriptor;

        FileSync(FileOutputStream fileOutputStream) throws IOException {
            this.outDescriptor = fileOutputStream.getFD();
        }

        @Override
        public void sync() throws IOException {
            this.outDescriptor.sync();
        }
    }
}

