/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.session.state;

import java.io.IOException;
import org.jsmpp.PDUStringException;
import org.jsmpp.bean.Bind;
import org.jsmpp.bean.Command;
import org.jsmpp.extra.SessionState;
import org.jsmpp.session.BaseResponseHandler;
import org.jsmpp.session.ServerResponseHandler;
import org.jsmpp.session.state.SMPPServerSessionState;
import org.jsmpp.util.DefaultDecomposer;
import org.jsmpp.util.PDUDecomposer;

class SMPPServerSessionOpen
implements SMPPServerSessionState {
    private static final String INVALID_PROCESS_FOR_OPEN_SESSION = "Invalid process for open session state";
    private static final PDUDecomposer pduDecomposer = new DefaultDecomposer();

    SMPPServerSessionOpen() {
    }

    @Override
    public SessionState getSessionState() {
        return SessionState.OPEN;
    }

    @Override
    public void processBind(Command pduHeader, byte[] pdu, ServerResponseHandler responseHandler) throws IOException {
        try {
            Bind bind = pduDecomposer.bind(pdu);
            responseHandler.processBind(bind);
        }
        catch (PDUStringException e) {
            responseHandler.sendNegativeResponse(pduHeader.getCommandId(), e.getErrorCode(), pduHeader.getSequenceNumber());
        }
        catch (IllegalArgumentException e) {
            responseHandler.sendNegativeResponse(pduHeader.getCommandId(), 3, pduHeader.getSequenceNumber());
        }
    }

    @Override
    public void processDeliverSmResp(Command pduHeader, byte[] pdu, ServerResponseHandler responseHandler) throws IOException {
        throw new IOException(INVALID_PROCESS_FOR_OPEN_SESSION);
    }

    @Override
    public void processQuerySm(Command pduHeader, byte[] pdu, ServerResponseHandler responseHandler) throws IOException {
        throw new IOException(INVALID_PROCESS_FOR_OPEN_SESSION);
    }

    @Override
    public void processSubmitSm(Command pduHeader, byte[] pdu, ServerResponseHandler responseHandler) throws IOException {
        throw new IOException(INVALID_PROCESS_FOR_OPEN_SESSION);
    }

    @Override
    public void processSubmitMulti(Command pduHeader, byte[] pdu, ServerResponseHandler responseHandler) throws IOException {
        throw new IOException(INVALID_PROCESS_FOR_OPEN_SESSION);
    }

    @Override
    public void processEnquireLink(Command pduHeader, byte[] pdu, BaseResponseHandler sessionHandler) throws IOException {
        throw new IOException(INVALID_PROCESS_FOR_OPEN_SESSION);
    }

    @Override
    public void processEnquireLinkResp(Command pduHeader, byte[] pdu, BaseResponseHandler sessionHandler) throws IOException {
        throw new IOException(INVALID_PROCESS_FOR_OPEN_SESSION);
    }

    @Override
    public void processGenericNack(Command pduHeader, byte[] pdu, BaseResponseHandler responseHandler) throws IOException {
        throw new IOException(INVALID_PROCESS_FOR_OPEN_SESSION);
    }

    @Override
    public void processUnbind(Command pduHeader, byte[] pdu, BaseResponseHandler sessionHandler) throws IOException {
        throw new IOException(INVALID_PROCESS_FOR_OPEN_SESSION);
    }

    @Override
    public void processUnbindResp(Command pduHeader, byte[] pdu, BaseResponseHandler sessionHandler) throws IOException {
        throw new IOException(INVALID_PROCESS_FOR_OPEN_SESSION);
    }

    @Override
    public void processUnknownCid(Command pduHeader, byte[] pdu, BaseResponseHandler sessionHandler) throws IOException {
        throw new IOException(INVALID_PROCESS_FOR_OPEN_SESSION);
    }

    @Override
    public void processDataSm(Command pduHeader, byte[] pdu, BaseResponseHandler responseHandler) throws IOException {
        throw new IOException(INVALID_PROCESS_FOR_OPEN_SESSION);
    }

    @Override
    public void processDataSmResp(Command pduHeader, byte[] pdu, BaseResponseHandler responseHandler) throws IOException {
        throw new IOException(INVALID_PROCESS_FOR_OPEN_SESSION);
    }

    @Override
    public void processCancelSm(Command pduHeader, byte[] pdu, ServerResponseHandler responseHandler) throws IOException {
        throw new IOException(INVALID_PROCESS_FOR_OPEN_SESSION);
    }

    @Override
    public void processReplaceSm(Command pduHeader, byte[] pdu, ServerResponseHandler responseHandler) throws IOException {
        throw new IOException(INVALID_PROCESS_FOR_OPEN_SESSION);
    }
}

