/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import oracle.security.pki.JCEUtil;
import oracle.security.pki.internal.asn1.ASN1Integer;
import oracle.security.pki.internal.asn1.ASN1Null;
import oracle.security.pki.internal.asn1.ASN1Object;
import oracle.security.pki.internal.asn1.ASN1ObjectID;
import oracle.security.pki.internal.asn1.ASN1OctetString;
import oracle.security.pki.internal.asn1.ASN1Sequence;
import oracle.security.pki.internal.asn1.ASN1SequenceInputStream;
import oracle.security.pki.internal.asn1.ASN1Utils;
import oracle.security.pki.internal.core.AlgID;
import oracle.security.pki.internal.core.AlgorithmIdentifier;
import oracle.security.pki.internal.core.AlgorithmIdentifierException;
import oracle.security.pki.util.Utils;

public class PBEAlgorithmIdentifier
extends AlgorithmIdentifier {
    public static final ASN1ObjectID a = new ASN1ObjectID(ASN1Utils.e, 5);
    public static final ASN1ObjectID b = new ASN1ObjectID(a, 1);
    public static final ASN1ObjectID c = new ASN1ObjectID(a, 4);
    public static final ASN1ObjectID d = new ASN1ObjectID(a, 3);
    public static final ASN1ObjectID e = new ASN1ObjectID(a, 6);
    public static final ASN1ObjectID f = new ASN1ObjectID(a, 10);
    public static final ASN1ObjectID g = new ASN1ObjectID(a, 11);
    public static final ASN1ObjectID h = new ASN1ObjectID(a, 12);
    public static final ASN1ObjectID i = new ASN1ObjectID(a, 13);
    public static final ASN1ObjectID j = new ASN1ObjectID(ASN1Utils.e, 12, 1);
    public static final ASN1ObjectID k = new ASN1ObjectID(j, 1);
    public static final ASN1ObjectID l = new ASN1ObjectID(j, 2);
    public static final ASN1ObjectID m = new ASN1ObjectID(j, 3);
    public static final ASN1ObjectID n = new ASN1ObjectID(j, 4);
    public static final ASN1ObjectID o = new ASN1ObjectID(j, 5);
    public static final ASN1ObjectID p = new ASN1ObjectID(j, 6);
    public static final int q = 8;
    private byte[] r;
    private int s;
    private int t;
    private AlgorithmIdentifier u;
    private AlgorithmIdentifier v;

    public PBEAlgorithmIdentifier(ASN1ObjectID aSN1ObjectID, byte[] byArray, int n) throws AlgorithmIdentifierException {
        super(aSN1ObjectID, PBEAlgorithmIdentifier.a(byArray, n));
        if (!(aSN1ObjectID.equals(b) || aSN1ObjectID.equals(c) || aSN1ObjectID.equals(d) || aSN1ObjectID.equals(e) || aSN1ObjectID.equals(f) || aSN1ObjectID.equals(g) || aSN1ObjectID.equals(k) || aSN1ObjectID.equals(l) || aSN1ObjectID.equals(m) || aSN1ObjectID.equals(PBEAlgorithmIdentifier.n) || aSN1ObjectID.equals(o) || aSN1ObjectID.equals(p) || aSN1ObjectID.equals(j))) {
            throw new AlgorithmIdentifierException("Invalid OID: " + aSN1ObjectID);
        }
        this.r = byArray;
        this.s = n;
    }

    public PBEAlgorithmIdentifier(int[] nArray, byte[] byArray, int n) throws AlgorithmIdentifierException {
        this(new ASN1ObjectID(nArray), byArray, n);
    }

    public PBEAlgorithmIdentifier(byte[] byArray, int n, int n2, AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2) throws AlgorithmIdentifierException {
        super(i, PBEAlgorithmIdentifier.a(byArray, n, n2, algorithmIdentifier, algorithmIdentifier2));
        this.r = byArray;
        this.s = n;
        this.t = n2;
        this.u = algorithmIdentifier;
        this.v = algorithmIdentifier2;
    }

    public PBEAlgorithmIdentifier(byte[] byArray, int n, AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        super(i, PBEAlgorithmIdentifier.a(byArray, n, 0, AlgID.X, algorithmIdentifier));
        this.r = byArray;
        this.s = n;
        this.u = AlgID.X;
        this.v = algorithmIdentifier;
        if (algorithmIdentifier.a().equals(AlgID.n.a())) {
            this.t = 16;
        } else if (algorithmIdentifier.a().equals(AlgID.p.a())) {
            this.t = 24;
        } else if (algorithmIdentifier.a().equals(AlgID.r.a())) {
            this.t = 32;
        }
    }

    public PBEAlgorithmIdentifier() throws IOException {
    }

    public PBEAlgorithmIdentifier(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public byte[] c() {
        return this.r;
    }

    public int d() {
        return this.s;
    }

    public int e() {
        return this.t;
    }

    public AlgorithmIdentifier f() {
        return this.u;
    }

    public AlgorithmIdentifier g() {
        return this.v;
    }

    private void h() throws AlgorithmIdentifierException {
        block17: {
            ASN1Object aSN1Object = this.b();
            try {
                if (aSN1Object == null || aSN1Object instanceof ASN1Null) {
                    SecureRandom secureRandom = JCEUtil.getSecureRandom();
                    this.r = new byte[8];
                    secureRandom.nextBytes(this.r);
                    this.s = 10000;
                    this.t = 0;
                    this.u = null;
                    this.v = null;
                    break block17;
                }
                if (this.a().equals(b) || this.a().equals(c) || this.a().equals(d) || this.a().equals(e) || this.a().equals(f) || this.a().equals(g) || this.a().equals(k) || this.a().equals(l) || this.a().equals(m) || this.a().equals(n) || this.a().equals(o) || this.a().equals(p)) {
                    ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(Utils.toStream(aSN1Object));
                    this.r = ASN1OctetString.a(aSN1SequenceInputStream);
                    this.s = ASN1Integer.b(aSN1SequenceInputStream).intValue();
                    aSN1SequenceInputStream.b();
                    this.t = 0;
                    this.u = null;
                    this.v = null;
                    break block17;
                }
                if (this.a().equals(i)) {
                    ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(Utils.toStream(aSN1Object));
                    ASN1SequenceInputStream aSN1SequenceInputStream2 = new ASN1SequenceInputStream(aSN1SequenceInputStream);
                    ASN1ObjectID aSN1ObjectID = new ASN1ObjectID(aSN1SequenceInputStream2);
                    if (!aSN1ObjectID.equals(h)) {
                        throw new AlgorithmIdentifierException("Invalid OID for the key derivation function");
                    }
                    ASN1SequenceInputStream aSN1SequenceInputStream3 = new ASN1SequenceInputStream(aSN1SequenceInputStream2);
                    this.r = ASN1OctetString.a(aSN1SequenceInputStream3);
                    this.s = ASN1Integer.b(aSN1SequenceInputStream3).intValue();
                    this.t = aSN1SequenceInputStream3.a() && aSN1SequenceInputStream3.d() == 2 ? ASN1Integer.b(aSN1SequenceInputStream3).intValue() : 0;
                    this.u = aSN1SequenceInputStream3.a() ? new AlgorithmIdentifier(aSN1SequenceInputStream3) : AlgID.X;
                    aSN1SequenceInputStream3.b();
                    aSN1SequenceInputStream2.b();
                    this.v = new AlgorithmIdentifier(aSN1SequenceInputStream);
                    if (this.t == 0) {
                        ASN1ObjectID aSN1ObjectID2 = this.v.a();
                        if (aSN1ObjectID2.equals(AlgID.b.a()) || aSN1ObjectID2.equals(AlgID.a.a())) {
                            this.t = 8;
                        }
                        if (aSN1ObjectID2.equals(AlgID.d.a()) || aSN1ObjectID2.equals(AlgID.c.a())) {
                            this.t = 24;
                        } else if (aSN1ObjectID2.equals(AlgID.i.a()) || aSN1ObjectID2.equals(AlgID.h.a()) || aSN1ObjectID2.equals(AlgID.n.a()) || aSN1ObjectID2.equals(AlgID.m.a())) {
                            this.t = 16;
                        } else if (aSN1ObjectID2.equals(AlgID.p.a()) || aSN1ObjectID2.equals(AlgID.o.a())) {
                            this.t = 24;
                        } else if (aSN1ObjectID2.equals(AlgID.r.a()) || aSN1ObjectID2.equals(AlgID.q.a())) {
                            this.t = 32;
                        } else if (aSN1ObjectID2.equals(AlgID.j.a()) || aSN1ObjectID2.equals(AlgID.l.a()) || aSN1ObjectID2.equals(AlgID.k.a())) {
                            this.t = 114;
                        }
                    }
                    aSN1SequenceInputStream.b();
                    break block17;
                }
                throw new AlgorithmIdentifierException("Invalid OID: " + this.a());
            }
            catch (IOException iOException) {
                throw new AlgorithmIdentifierException(iOException.toString());
            }
        }
    }

    private static ASN1Object a(byte[] byArray, int n) {
        if (byArray == null) {
            return null;
        }
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.a(new ASN1OctetString(byArray));
        aSN1Sequence.a(new ASN1Integer(n));
        return aSN1Sequence;
    }

    private static ASN1Object a(byte[] byArray, int n, int n2, AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2) {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        ASN1Sequence aSN1Sequence2 = new ASN1Sequence();
        aSN1Sequence2.a(h);
        ASN1Sequence aSN1Sequence3 = new ASN1Sequence();
        aSN1Sequence3.a(new ASN1OctetString(byArray));
        aSN1Sequence3.a(new ASN1Integer(n));
        if (n2 > 0) {
            aSN1Sequence3.a(new ASN1Integer(n2));
        }
        if (!AlgID.X.a().equals(algorithmIdentifier.a())) {
            aSN1Sequence3.a(algorithmIdentifier);
        }
        aSN1Sequence2.a(aSN1Sequence3);
        aSN1Sequence.a(aSN1Sequence2);
        aSN1Sequence.a(algorithmIdentifier2);
        return aSN1Sequence;
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        super.input(inputStream);
        try {
            this.h();
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new IOException(algorithmIdentifierException.toString());
        }
    }

    @Override
    public Object clone() {
        byte[] byArray = this.r != null ? (byte[])this.r.clone() : null;
        try {
            PBEAlgorithmIdentifier pBEAlgorithmIdentifier;
            if (byArray != null) {
                pBEAlgorithmIdentifier = new PBEAlgorithmIdentifier(this.a(), byArray, this.s);
            } else {
                SecureRandom secureRandom = JCEUtil.getSecureRandom();
                this.r = new byte[8];
                secureRandom.nextBytes(this.r);
                pBEAlgorithmIdentifier = new PBEAlgorithmIdentifier(this.a(), this.r, 10000);
            }
            pBEAlgorithmIdentifier.t = this.t;
            if (this.u != null) {
                pBEAlgorithmIdentifier.u = (AlgorithmIdentifier)this.u.clone();
            }
            if (this.v != null) {
                pBEAlgorithmIdentifier.v = (AlgorithmIdentifier)this.v.clone();
            }
            return pBEAlgorithmIdentifier;
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new IllegalStateException(algorithmIdentifierException.toString());
        }
    }
}

