/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.math.BigInteger;
import org.bouncycastle.crypto.IllegalKeyException;
import org.bouncycastle.crypto.fips.DhBasicAgreement;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.params.DhuPrivateParameters;
import org.bouncycastle.crypto.internal.params.DhuPublicParameters;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;

class DhuBasicAgreement {
    DhuPrivateParameters privParams;

    DhuBasicAgreement() {
    }

    public void init(CipherParameters cipherParameters) {
        this.privParams = (DhuPrivateParameters)cipherParameters;
    }

    public int getFieldSize() {
        return (this.privParams.getStaticPrivateKey().getParameters().getP().bitLength() + 7) / 8;
    }

    public byte[] calculateAgreement(CipherParameters cipherParameters) {
        DhuPublicParameters dhuPublicParameters = (DhuPublicParameters)cipherParameters;
        if (!this.privParams.getStaticPrivateKey().getParameters().equals(dhuPublicParameters.getStaticPublicKey().getParameters())) {
            throw new IllegalKeyException("DHU public key components have wrong domain parameters");
        }
        DhBasicAgreement dhBasicAgreement = new DhBasicAgreement();
        DhBasicAgreement dhBasicAgreement2 = new DhBasicAgreement();
        dhBasicAgreement.init(this.privParams.getStaticPrivateKey());
        BigInteger bigInteger = dhBasicAgreement.calculateAgreement(dhuPublicParameters.getStaticPublicKey());
        dhBasicAgreement2.init(this.privParams.getEphemeralPrivateKey());
        BigInteger bigInteger2 = dhBasicAgreement2.calculateAgreement(dhuPublicParameters.getEphemeralPublicKey());
        return Arrays.concatenate(BigIntegers.asUnsignedByteArray(this.getFieldSize(), bigInteger2), BigIntegers.asUnsignedByteArray(this.getFieldSize(), bigInteger));
    }
}

