/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.IsObjectNode;
import com.oracle.truffle.js.nodes.intl.GetOptionsObjectNode;
import com.oracle.truffle.js.nodes.temporal.GetTemporalCalendarIdentifierWithISODefaultNode;
import com.oracle.truffle.js.nodes.temporal.TemporalGetOptionNode;
import com.oracle.truffle.js.nodes.temporal.TemporalMonthDayFromFieldsNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.temporal.ISODateRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDateTimeRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainMonthDay;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainMonthDayObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.util.IntlUtil;
import com.oracle.truffle.js.runtime.util.TemporalConstants;
import com.oracle.truffle.js.runtime.util.TemporalErrors;
import com.oracle.truffle.js.runtime.util.TemporalUtil;

public abstract class ToTemporalMonthDayNode
extends JavaScriptBaseNode {
    protected ToTemporalMonthDayNode() {
    }

    public abstract JSTemporalPlainMonthDayObject execute(Object var1, Object var2);

    @Specialization
    public JSTemporalPlainMonthDayObject iso8601CalendarProfile(Object item, Object options, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile isObjectProfile, @Cached InlinedConditionProfile iso8601CalendarProfile, @Cached IsObjectNode isObjectNode, @Cached(value="create(getJSContext())") GetOptionsObjectNode getOptionsObject, @Cached GetTemporalCalendarIdentifierWithISODefaultNode getTemporalCalendar, @Cached TemporalGetOptionNode temporalGetOptionNode, @Cached TemporalMonthDayFromFieldsNode monthDayFromFieldsNode, @Cached TruffleString.ToJavaStringNode toJavaString, @Cached TruffleString.FromJavaStringNode fromJavaString, @Cached TruffleString.EqualNode stringEqual) {
        JSContext ctx = this.getLanguage().getJSContext();
        JSRealm realm = this.getRealm();
        if (isObjectProfile.profile((Node)this, isObjectNode.executeBoolean(item))) {
            if (JSTemporalPlainMonthDay.isJSTemporalPlainMonthDay(item)) {
                Object resolvedOptions = getOptionsObject.execute(options);
                TemporalUtil.getTemporalOverflowOption(resolvedOptions, temporalGetOptionNode);
                JSTemporalPlainMonthDayObject pmd = (JSTemporalPlainMonthDayObject)((Object)item);
                return JSTemporalPlainMonthDay.create(ctx, realm, pmd.getMonth(), pmd.getDay(), pmd.getCalendar(), pmd.getYear(), this, errorBranch);
            }
            TruffleString calendar = getTemporalCalendar.execute(item);
            JSObject fields = TemporalUtil.prepareCalendarFields(ctx, calendar, item, TemporalUtil.listDMMCY, TemporalUtil.listEmpty, TemporalUtil.listEmpty);
            Object resolvedOptions = getOptionsObject.execute(options);
            TemporalUtil.Overflow overflow = TemporalUtil.getTemporalOverflowOption(resolvedOptions, temporalGetOptionNode);
            return monthDayFromFieldsNode.execute(calendar, fields, overflow);
        }
        if (item instanceof TruffleString) {
            TruffleString string = (TruffleString)item;
            JSTemporalDateTimeRecord result = TemporalUtil.parseTemporalMonthDayString(string);
            TruffleString calendar = result.getCalendar();
            if (calendar == null) {
                calendar = TemporalConstants.ISO8601;
            } else {
                String calendarJLS = toJavaString.execute((AbstractTruffleString)calendar);
                calendar = Strings.fromJavaString(fromJavaString, IntlUtil.canonicalizeCalendar(calendarJLS));
            }
            Object resolvedOptions = getOptionsObject.execute(options);
            TemporalUtil.getTemporalOverflowOption(resolvedOptions, temporalGetOptionNode);
            if (iso8601CalendarProfile.profile((Node)this, Strings.equals(stringEqual, calendar, TemporalConstants.ISO8601))) {
                int referenceISOYear = 1972;
                return JSTemporalPlainMonthDay.create(ctx, realm, result.getMonth(), result.getDay(), calendar, referenceISOYear, this, errorBranch);
            }
            ISODateRecord isoDate = TemporalUtil.createISODateRecord(result.getYear(), result.getMonth(), result.getDay());
            if (!TemporalUtil.isoDateWithinLimits(isoDate.year(), isoDate.month(), isoDate.day())) {
                errorBranch.enter((Node)this);
                throw TemporalErrors.createRangeErrorMonthDayOutsideRange();
            }
            JSObject result2 = TemporalUtil.isoDateToFields(ctx, calendar, isoDate, TemporalUtil.FieldsType.MONTH_DAY);
            return monthDayFromFieldsNode.execute(calendar, result2, TemporalUtil.Overflow.CONSTRAIN);
        }
        errorBranch.enter((Node)this);
        throw Errors.createTypeErrorNotAString(item);
    }
}

