/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.frame;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.cell.PCell;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.frame.PFrame;
import com.oracle.graal.python.compiler.CodeUnit;
import com.oracle.graal.python.lib.PyDictGetItem;
import com.oracle.graal.python.nodes.PRootNode;
import com.oracle.graal.python.nodes.bytecode.FrameInfo;
import com.oracle.graal.python.nodes.bytecode_dsl.BytecodeDSLFrameInfo;
import com.oracle.graal.python.nodes.bytecode_dsl.PBytecodeDSLRootNode;
import com.oracle.graal.python.nodes.frame.GetFrameLocalsNodeGen;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.bytecode.BytecodeNode;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateUncached
@GenerateInline(inlineByDefault=true)
@GenerateCached
public abstract class GetFrameLocalsNode
extends Node {
    public abstract Object execute(Node var1, PFrame var2);

    public final Object executeCached(PFrame pyFrame) {
        return this.execute(this, pyFrame);
    }

    public static Object executeUncached(PFrame pyFrame) {
        return GetFrameLocalsNodeGen.getUncached().execute(null, pyFrame);
    }

    @Specialization(guards={"!pyFrame.hasCustomLocals()"})
    static Object doLoop(Node inliningTarget, PFrame pyFrame, @Cached InlinedBranchProfile create, @Cached(inline=false) CopyLocalsToDict copyLocalsToDict) {
        MaterializedFrame locals = pyFrame.getLocals();
        PDict localsDict = (PDict)pyFrame.getLocalsDict();
        if (localsDict == null) {
            create.enter(inliningTarget);
            localsDict = PFactory.createDict(PythonLanguage.get(inliningTarget));
            pyFrame.setLocalsDict(localsDict);
        }
        copyLocalsToDict.execute(locals, localsDict);
        return localsDict;
    }

    @Specialization(guards={"pyFrame.hasCustomLocals()"})
    static Object doCustomLocals(PFrame pyFrame) {
        Object localsDict = pyFrame.getLocalsDict();
        assert (localsDict != null);
        return localsDict;
    }

    public static void syncLocalsBackToFrame(CodeUnit co, PRootNode root, PFrame pyFrame, Frame localFrame) {
        if (!pyFrame.hasCustomLocals()) {
            PDict localsDict = (PDict)pyFrame.getLocalsDict();
            GetFrameLocalsNode.copyLocalsArray(localFrame, root, localsDict, co.varnames, 0, false);
            GetFrameLocalsNode.copyLocalsArray(localFrame, root, localsDict, co.cellvars, co.varnames.length, true);
            GetFrameLocalsNode.copyLocalsArray(localFrame, root, localsDict, co.freevars, co.varnames.length + co.cellvars.length, true);
        }
    }

    private static void copyLocalsArray(Frame localFrame, PRootNode root, PDict localsDict, TruffleString[] namesArray, int offset, boolean deref) {
        if (PythonOptions.ENABLE_BYTECODE_DSL_INTERPRETER) {
            PBytecodeDSLRootNode bytecodeDSLRootNode = (PBytecodeDSLRootNode)root;
            BytecodeNode bytecodeNode = bytecodeDSLRootNode.getBytecodeNode();
            for (int i = 0; i < namesArray.length; ++i) {
                TruffleString varname = namesArray[i];
                Object value = PyDictGetItem.executeUncached(localsDict, varname);
                if (deref) {
                    PCell cell = (PCell)bytecodeNode.getLocalValue(0, localFrame, offset + i);
                    cell.setRef(value);
                    continue;
                }
                bytecodeNode.setLocalValue(0, localFrame, offset + i, value);
            }
        } else {
            for (int i = 0; i < namesArray.length; ++i) {
                TruffleString varname = namesArray[i];
                Object value = PyDictGetItem.executeUncached(localsDict, varname);
                if (deref) {
                    PCell cell = (PCell)localFrame.getObject(offset + i);
                    cell.setRef(value);
                    continue;
                }
                localFrame.setObject(offset + i, value);
            }
        }
    }

    @NeverDefault
    public static GetFrameLocalsNode create() {
        return GetFrameLocalsNodeGen.create();
    }

    @GenerateUncached
    @GenerateInline(value=false)
    static abstract class CopyLocalsToDict
    extends Node {
        CopyLocalsToDict() {
        }

        abstract void execute(MaterializedFrame var1, PDict var2);

        @Specialization(guards={"cachedFd == locals.getFrameDescriptor()", "count < 32"}, limit="1")
        @ExplodeLoop
        void doCachedFd(MaterializedFrame locals, PDict dict, @Bind Node inliningTarget, @Cached(value="locals.getFrameDescriptor()") FrameDescriptor cachedFd, @Bind(value="getInfo(cachedFd)") FrameInfo info, @Bind(value="info.getVariableCount()") int count, @Cached.Shared(value="setItem") @Cached HashingStorageNodes.HashingStorageSetItem setItem, @Cached.Shared(value="delItem") @Cached HashingStorageNodes.HashingStorageDelItem delItem) {
            int regularVarCount = info.getRegularVariableCount();
            if (PythonOptions.ENABLE_BYTECODE_DSL_INTERPRETER) {
                BytecodeDSLFrameInfo bytecodeDSLFrameInfo = (BytecodeDSLFrameInfo)info;
                PBytecodeDSLRootNode rootNode = bytecodeDSLFrameInfo.getRootNode();
                Object[] localsArray = rootNode.getBytecodeNode().getLocalValues(0, (Frame)locals);
                for (int i = 0; i < count; ++i) {
                    CopyLocalsToDict.copyItem(inliningTarget, localsArray[i], info, dict, setItem, delItem, i, i >= regularVarCount);
                }
            } else {
                for (int i = 0; i < count; ++i) {
                    CopyLocalsToDict.copyItem(inliningTarget, locals.getValue(i), info, dict, setItem, delItem, i, i >= regularVarCount);
                }
            }
        }

        @Specialization(replaces={"doCachedFd"})
        void doGeneric(MaterializedFrame locals, PDict dict, @Bind Node inliningTarget, @Cached.Shared(value="setItem") @Cached HashingStorageNodes.HashingStorageSetItem setItem, @Cached.Shared(value="delItem") @Cached HashingStorageNodes.HashingStorageDelItem delItem) {
            FrameInfo info = CopyLocalsToDict.getInfo(locals.getFrameDescriptor());
            int count = info.getVariableCount();
            int regularVarCount = info.getRegularVariableCount();
            if (PythonOptions.ENABLE_BYTECODE_DSL_INTERPRETER) {
                BytecodeDSLFrameInfo bytecodeDSLFrameInfo = (BytecodeDSLFrameInfo)info;
                PBytecodeDSLRootNode rootNode = bytecodeDSLFrameInfo.getRootNode();
                Object[] localsArray = rootNode.getBytecodeNode().getLocalValues(0, (Frame)locals);
                for (int i = 0; i < count; ++i) {
                    CopyLocalsToDict.copyItem(inliningTarget, localsArray[i], info, dict, setItem, delItem, i, i >= regularVarCount);
                }
            } else {
                for (int i = 0; i < count; ++i) {
                    CopyLocalsToDict.copyItem(inliningTarget, locals.getValue(i), info, dict, setItem, delItem, i, i >= regularVarCount);
                }
            }
        }

        private static void copyItem(Node inliningTarget, Object localValue, FrameInfo info, PDict dict, HashingStorageNodes.HashingStorageSetItem setItem, HashingStorageNodes.HashingStorageDelItem delItem, int i, boolean deref) {
            TruffleString name = info.getVariableName(i);
            Object value = localValue;
            if (deref && value != null) {
                value = ((PCell)value).getRef();
            }
            if (value == null) {
                delItem.execute(inliningTarget, dict.getDictStorage(), name, dict);
            } else {
                HashingStorage storage = setItem.execute(inliningTarget, dict.getDictStorage(), name, value);
                dict.setDictStorage(storage);
            }
        }

        @Idempotent
        protected static FrameInfo getInfo(FrameDescriptor fd) {
            return (FrameInfo)fd.getInfo();
        }
    }
}

