/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.backend.panama;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.nfi.backend.panama.PanamaNFILanguage;
import java.lang.foreign.MemorySegment;

@ExportLibrary(value=InteropLibrary.class)
class NativeString
implements TruffleObject {
    final long nativePointer;

    NativeString(long nativePointer) {
        this.nativePointer = nativePointer;
    }

    @ExportMessage
    boolean isNull() {
        return this.nativePointer == 0L;
    }

    @ExportMessage
    boolean isString() {
        return this.nativePointer != 0L;
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    String asString() {
        return MemorySegment.ofAddress(this.nativePointer).getString(0L);
    }

    @ExportMessage
    boolean isPointer() {
        return true;
    }

    @ExportMessage
    long asPointer() {
        return this.nativePointer;
    }

    @ExportMessage
    boolean hasLanguage() {
        return true;
    }

    @ExportMessage
    Class<? extends TruffleLanguage<?>> getLanguage() {
        return PanamaNFILanguage.class;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object toDisplayString(boolean allowSideEffects) {
        return "NativeString(" + this.asString() + ")";
    }
}

