/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.repository.manager;

import com.ibm.db2.cmx.runtime.internal.repository.MetadataException;
import com.ibm.db2.cmx.runtime.internal.repository.api.AnalysisInfo;
import com.ibm.db2.cmx.runtime.internal.repository.api.AnalysisManager;
import com.ibm.db2.cmx.runtime.internal.repository.api.RepositoryVersion;
import com.ibm.db2.cmx.runtime.internal.repository.api.RuntimeGroupManager;
import com.ibm.db2.cmx.runtime.internal.repository.api.SavedData;
import com.ibm.db2.cmx.runtime.internal.repository.api.SavedDataInfo;
import com.ibm.db2.cmx.runtime.internal.repository.manager.RepositorySetupManagerImpl;
import com.ibm.db2.cmx.runtime.internal.repository.manager.RuntimeGroupManagerImpl;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.BaseMetadataLoader;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.RuntimeGroupMetadataLoader;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.DBInfoWriter;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.StackWriter;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.StmtWriter;
import com.ibm.db2.cmx.runtime.internal.repository.util.Filter;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.util.EnumSet;
import java.util.Map;

public class AnalysisManagerImpl
implements AnalysisManager {
    private Connection c = null;
    private String schema = null;

    public AnalysisManagerImpl(Connection connection, String string) {
        this.c = connection;
        this.schema = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AnalysisInfo analyzeRuntimeGroup(String string, String string2) throws MetadataException {
        AnalysisInfo analysisInfo = null;
        RuntimeGroupManagerImpl runtimeGroupManagerImpl = new RuntimeGroupManagerImpl(this.c, this.schema);
        EnumSet<RuntimeGroupManager.MemberType> enumSet = EnumSet.of(RuntimeGroupManager.MemberType.PDQXML);
        Map<RuntimeGroupManager.MemberType, SavedData> map = runtimeGroupManagerImpl.getData(string, string2, enumSet);
        InputStream inputStream = null;
        SavedData savedData = map.get((Object)RuntimeGroupManager.MemberType.PDQXML);
        if (savedData != null && savedData.getContentStream() != null) {
            inputStream = savedData.getContentStream();
            try {
                analysisInfo = this.analyzeRuntimeGroup(string, string2, inputStream, savedData.getSavedDataInfo().getKey());
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    String string3 = Messages.getText("ERR_CANNOT_READ_PDQXML_CONTENT_FOR_RUNTIMEID_VERSION", string, string2);
                    throw new MetadataException(string3, iOException);
                }
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                String string4 = Messages.getText("ERR_CANNOT_READ_PDQXML_CONTENT_FOR_RUNTIMEID_VERSION", string, string2);
                throw new MetadataException(string4, iOException);
            }
        }
        return analysisInfo;
    }

    protected AnalysisInfo analyzeRuntimeGroup(String string, String string2, InputStream inputStream, int n2) throws MetadataException {
        if (BaseMetadataLoader.getStackTraceFilter() == null) {
            AnalysisManagerImpl.initStackTraceFilter();
        }
        RuntimeGroupMetadataLoader runtimeGroupMetadataLoader = new RuntimeGroupMetadataLoader(this.c, this.schema);
        runtimeGroupMetadataLoader.load(inputStream, "PDQXML", null, null, n2);
        return runtimeGroupMetadataLoader.getLoaderInfo();
    }

    protected AnalysisInfo analyzeApp(int n2, String string, InputStream inputStream, int n3) throws MetadataException {
        if (BaseMetadataLoader.getStackTraceFilter() == null) {
            AnalysisManagerImpl.initStackTraceFilter();
        }
        RuntimeGroupMetadataLoader runtimeGroupMetadataLoader = new RuntimeGroupMetadataLoader(this.c, this.schema);
        runtimeGroupMetadataLoader.getMetadataCache().setAppKey(n2);
        runtimeGroupMetadataLoader.load(inputStream, string, null, null, n3);
        return runtimeGroupMetadataLoader.getLoaderInfo();
    }

    @Override
    public boolean isAnalysisAvailable() throws MetadataException {
        RepositorySetupManagerImpl repositorySetupManagerImpl = new RepositorySetupManagerImpl(this.c);
        RepositoryVersion repositoryVersion = repositorySetupManagerImpl.getRepositoryVersion(this.schema);
        return repositoryVersion.isFullRepository();
    }

    @Override
    public void removeAnalysisData(String string, String string2) throws MetadataException {
        RuntimeGroupManagerImpl runtimeGroupManagerImpl = new RuntimeGroupManagerImpl(this.c, this.schema);
        EnumSet<RuntimeGroupManager.MemberType> enumSet = EnumSet.of(RuntimeGroupManager.MemberType.PDQXML);
        Map<RuntimeGroupManager.MemberType, SavedDataInfo> map = runtimeGroupManagerImpl.getSavedDataInfo(string, string2, enumSet);
        SavedDataInfo savedDataInfo = map.get((Object)RuntimeGroupManager.MemberType.PDQXML);
        if (savedDataInfo != null) {
            int n2 = savedDataInfo.getKey();
            StmtWriter stmtWriter = StmtWriter.getInstance(this.schema);
            StackWriter stackWriter = StackWriter.getInstance(this.schema);
            stmtWriter.removeStmtsForMetadataSource(this.c, n2);
            stackWriter.removeStacksForMetadataSource(this.c, n2);
            DBInfoWriter dBInfoWriter = DBInfoWriter.getInstance(this.schema);
            dBInfoWriter.removeOrphanedEntries(this.c);
        }
    }

    private static void initStackTraceFilter() throws MetadataException {
        String string = "/com/ibm/pdq/runtime/internal/repository/config/ProfilerFilter.ini";
        InputStream inputStream = null;
        try {
            inputStream = RuntimeGroupManagerImpl.getDefaultContent(string);
            Filter filter = Filter.loadFrom(inputStream);
            BaseMetadataLoader.setStackTraceFilter(filter);
        }
        catch (IOException iOException) {
            String string2 = Messages.getText("ERR_CANNOT_READ_DEFAULT_STACK_TRACE_FILTER", string);
            throw new MetadataException(string2, iOException);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }
}

