/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Year;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import org.zaproxy.zap.extension.api.AbstractAPIGenerator;
import org.zaproxy.zap.extension.api.ApiElement;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiParameter;

public class PythonAPIGenerator
extends AbstractAPIGenerator {
    private static final String DEFAULT_OUTPUT_DIR = "../zap-api-python/src/zapv2/";
    private final String HEADER = "# Zed Attack Proxy (ZAP) and its related class files.\n#\n# ZAP is an HTTP/HTTPS proxy for assessing web application security.\n#\n# Copyright " + String.valueOf(Year.now()) + " the ZAP development team\n#\n# Licensed under the Apache License, Version 2.0 (the \"License\");\n# you may not use this file except in compliance with the License.\n# You may obtain a copy of the License at\n#\n#   http://www.apache.org/licenses/LICENSE-2.0\n#\n# Unless required by applicable law or agreed to in writing, software\n# distributed under the License is distributed on an \"AS IS\" BASIS,\n# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n# See the License for the specific language governing permissions and\n# limitations under the License.\n\"\"\"\nThis file was automatically generated.\n\"\"\"\n\n";
    private static final Map<String, Set<String>> NON_WRAPPED_API_ELEMENTS = Map.of("automation", Set.of("planProgress"), "stats", Set.of("stats"), "users", Set.of("getUserById"));
    private static final Map<String, String> nameMap;

    public PythonAPIGenerator() {
        super(DEFAULT_OUTPUT_DIR);
    }

    public PythonAPIGenerator(String path, boolean optional) {
        super(path, optional);
    }

    public PythonAPIGenerator(String path, boolean optional, ResourceBundle resourceBundle) {
        super(path, optional, resourceBundle);
    }

    private void generatePythonElement(ApiElement element, String component, String type, Writer out) throws IOException {
        boolean hasParams;
        block16: {
            out.write("\n\n");
            boolean bl = hasParams = !element.getParameters().isEmpty();
            if (!hasParams && type.equals("view")) {
                out.write("    @property\n");
            }
            out.write("    def " + PythonAPIGenerator.createFunctionName(element.getName()) + "(self");
            for (ApiParameter parameter : element.getParameters()) {
                out.write(", " + parameter.getName().toLowerCase(Locale.ROOT));
                if (parameter.isRequired()) continue;
                out.write("=None");
            }
            if (type.equals("action") || type.equals("other")) {
                out.write(", apikey=''");
                hasParams = true;
            }
            out.write("):\n");
            String descTag = element.getDescriptionTag();
            try {
                String desc = this.getMessages().getString(descTag);
                out.write("        \"\"\"\n");
                out.write("        " + desc + "\n");
                if (this.isOptional()) {
                    out.write("        This component is optional and therefore the API will only work if it is installed\n");
                }
                out.write("        \"\"\"\n");
            }
            catch (Exception e2) {
                System.out.println("No i18n for: " + descTag);
                if (!this.isOptional()) break block16;
                out.write("        \"\"\"\n");
                out.write("        This component is optional and therefore the API will only work if it is installed\n");
                out.write("        \"\"\"\n");
            }
        }
        Object method = "_request";
        Object baseUrl = "base";
        if (type.equals("other")) {
            method = (String)method + "_other";
            baseUrl = (String)baseUrl + "_other";
        }
        StringBuilder reqParams = new StringBuilder();
        if (hasParams) {
            reqParams.append("{");
            String mandatoryParameters = element.getParameters().stream().filter(ApiParameter::isRequired).map(ApiParameter::getName).map(name -> "'" + name + "': " + name.toLowerCase(Locale.ROOT)).collect(Collectors.joining(", "));
            reqParams.append(mandatoryParameters);
            reqParams.append("}");
            List optionalParameters = element.getParameters().stream().filter(e -> !e.isRequired()).collect(Collectors.toList());
            if (!optionalParameters.isEmpty()) {
                out.write("        params = ");
                out.write(reqParams.toString());
                out.write("\n");
                reqParams.replace(0, reqParams.length(), "params");
                for (ApiParameter parameter : optionalParameters) {
                    String name2 = parameter.getName();
                    String varName = name2.toLowerCase(Locale.ROOT);
                    out.write("        if " + varName + " is not None:\n");
                    out.write("            params['" + name2 + "'] = " + varName + "\n");
                }
            }
        }
        boolean unwrap = !type.equals("other") && PythonAPIGenerator.isUnwrapRequired(component, element);
        out.write("        return ");
        if (unwrap) {
            out.write("six.next(six.itervalues");
        }
        out.write("(");
        out.write("self.zap." + (String)method + "(self.zap." + (String)baseUrl + " + '" + component + "/" + type + "/" + element.getName() + "/'");
        if (hasParams) {
            out.write(", ");
            String httpMethod = element.getDefaultMethod();
            if (!"GET".equalsIgnoreCase(httpMethod)) {
                out.write("method=\"");
                out.write(httpMethod);
                out.write(34);
                out.write(", body=");
            }
            out.write(reqParams.toString());
            out.write(")");
            if (unwrap) {
                out.write(")");
            }
        } else if (unwrap) {
            out.write("))");
        }
        out.write(")");
    }

    private static boolean isUnwrapRequired(String component, ApiElement element) {
        return !NON_WRAPPED_API_ELEMENTS.getOrDefault(component, Set.of()).contains(element.getName());
    }

    @Override
    protected void generateAPIFiles(ApiImplementor imp) throws IOException {
        Path file = this.getDirectory().resolve(PythonAPIGenerator.createFileName(imp.getPrefix()));
        System.out.println("Generating " + String.valueOf(file.toAbsolutePath()));
        try (BufferedWriter out = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
            out.write(this.HEADER);
            out.write("import six\n\n\n");
            out.write("class " + PythonAPIGenerator.safeName(imp.getPrefix()) + "(object):\n\n");
            out.write("    def __init__(self, zap):\n");
            out.write("        self.zap = zap");
            for (ApiElement apiElement : imp.getApiViews()) {
                this.generatePythonElement(apiElement, imp.getPrefix(), "view", out);
            }
            for (ApiElement apiElement : imp.getApiActions()) {
                this.generatePythonElement(apiElement, imp.getPrefix(), "action", out);
            }
            for (ApiElement apiElement : imp.getApiOthers()) {
                this.generatePythonElement(apiElement, imp.getPrefix(), "other", out);
            }
            out.write("\n");
        }
    }

    private static String safeName(String name) {
        if (nameMap.containsKey(name)) {
            return nameMap.get(name);
        }
        return name;
    }

    private static String createFileName(String name) {
        return PythonAPIGenerator.safeName(name) + ".py";
    }

    private static String createFunctionName(String name) {
        return PythonAPIGenerator.removeAllFullStopCharacters(PythonAPIGenerator.camelCaseToLcUnderscores(PythonAPIGenerator.safeName(name)));
    }

    private static String removeAllFullStopCharacters(String string) {
        return string.replaceAll("\\.", "");
    }

    public static String camelCaseToLcUnderscores(String s) {
        return PythonAPIGenerator.safeName(s).replaceAll(String.format("%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])"), "_").toLowerCase();
    }

    public static void main(String[] args) throws Exception {
        if (!Files.exists(Paths.get(DEFAULT_OUTPUT_DIR, new String[0]), new LinkOption[0])) {
            System.err.println("The directory does not exist: " + String.valueOf(Paths.get(DEFAULT_OUTPUT_DIR, new String[0]).toAbsolutePath()));
            System.exit(1);
        }
        PythonAPIGenerator wapi = new PythonAPIGenerator();
        wapi.generateCoreAPIFiles();
    }

    static {
        HashMap<String, String> initMap = new HashMap<String, String>();
        initMap.put("break", "brk");
        initMap.put("continue", "cont");
        nameMap = Collections.unmodifiableMap(initMap);
    }
}

