﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/backup/Backup_EXPORTS.h>
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Backup {
namespace Model {
class CreateRestoreTestingSelectionResult {
 public:
  AWS_BACKUP_API CreateRestoreTestingSelectionResult() = default;
  AWS_BACKUP_API CreateRestoreTestingSelectionResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_BACKUP_API CreateRestoreTestingSelectionResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The time that the resource testing selection was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreationTime() const { return m_creationTime; }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  void SetCreationTime(CreationTimeT&& value) {
    m_creationTimeHasBeenSet = true;
    m_creationTime = std::forward<CreationTimeT>(value);
  }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  CreateRestoreTestingSelectionResult& WithCreationTime(CreationTimeT&& value) {
    SetCreationTime(std::forward<CreationTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ARN of the restore testing plan with which the restore testing selection
   * is associated.</p>
   */
  inline const Aws::String& GetRestoreTestingPlanArn() const { return m_restoreTestingPlanArn; }
  template <typename RestoreTestingPlanArnT = Aws::String>
  void SetRestoreTestingPlanArn(RestoreTestingPlanArnT&& value) {
    m_restoreTestingPlanArnHasBeenSet = true;
    m_restoreTestingPlanArn = std::forward<RestoreTestingPlanArnT>(value);
  }
  template <typename RestoreTestingPlanArnT = Aws::String>
  CreateRestoreTestingSelectionResult& WithRestoreTestingPlanArn(RestoreTestingPlanArnT&& value) {
    SetRestoreTestingPlanArn(std::forward<RestoreTestingPlanArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the restore testing plan.</p> <p>The name cannot be changed after
   * creation. The name consists of only alphanumeric characters and underscores.
   * Maximum length is 50.</p>
   */
  inline const Aws::String& GetRestoreTestingPlanName() const { return m_restoreTestingPlanName; }
  template <typename RestoreTestingPlanNameT = Aws::String>
  void SetRestoreTestingPlanName(RestoreTestingPlanNameT&& value) {
    m_restoreTestingPlanNameHasBeenSet = true;
    m_restoreTestingPlanName = std::forward<RestoreTestingPlanNameT>(value);
  }
  template <typename RestoreTestingPlanNameT = Aws::String>
  CreateRestoreTestingSelectionResult& WithRestoreTestingPlanName(RestoreTestingPlanNameT&& value) {
    SetRestoreTestingPlanName(std::forward<RestoreTestingPlanNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the restore testing selection for the related restore testing
   * plan.</p> <p>The name cannot be changed after creation. The name consists of
   * only alphanumeric characters and underscores. Maximum length is 50.</p>
   */
  inline const Aws::String& GetRestoreTestingSelectionName() const { return m_restoreTestingSelectionName; }
  template <typename RestoreTestingSelectionNameT = Aws::String>
  void SetRestoreTestingSelectionName(RestoreTestingSelectionNameT&& value) {
    m_restoreTestingSelectionNameHasBeenSet = true;
    m_restoreTestingSelectionName = std::forward<RestoreTestingSelectionNameT>(value);
  }
  template <typename RestoreTestingSelectionNameT = Aws::String>
  CreateRestoreTestingSelectionResult& WithRestoreTestingSelectionName(RestoreTestingSelectionNameT&& value) {
    SetRestoreTestingSelectionName(std::forward<RestoreTestingSelectionNameT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateRestoreTestingSelectionResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Utils::DateTime m_creationTime{};

  Aws::String m_restoreTestingPlanArn;

  Aws::String m_restoreTestingPlanName;

  Aws::String m_restoreTestingSelectionName;

  Aws::String m_requestId;
  bool m_creationTimeHasBeenSet = false;
  bool m_restoreTestingPlanArnHasBeenSet = false;
  bool m_restoreTestingPlanNameHasBeenSet = false;
  bool m_restoreTestingSelectionNameHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Backup
}  // namespace Aws
