﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/lexv2-models/LexModelsV2_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace LexModelsV2 {
namespace Model {

/**
 * <p>The configuration details of the Qinconnect assistant.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/QInConnectAssistantConfiguration">AWS
 * API Reference</a></p>
 */
class QInConnectAssistantConfiguration {
 public:
  AWS_LEXMODELSV2_API QInConnectAssistantConfiguration() = default;
  AWS_LEXMODELSV2_API QInConnectAssistantConfiguration(Aws::Utils::Json::JsonView jsonValue);
  AWS_LEXMODELSV2_API QInConnectAssistantConfiguration& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_LEXMODELSV2_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The assistant Arn details of the Qinconnect assistant configuration.</p>
   */
  inline const Aws::String& GetAssistantArn() const { return m_assistantArn; }
  inline bool AssistantArnHasBeenSet() const { return m_assistantArnHasBeenSet; }
  template <typename AssistantArnT = Aws::String>
  void SetAssistantArn(AssistantArnT&& value) {
    m_assistantArnHasBeenSet = true;
    m_assistantArn = std::forward<AssistantArnT>(value);
  }
  template <typename AssistantArnT = Aws::String>
  QInConnectAssistantConfiguration& WithAssistantArn(AssistantArnT&& value) {
    SetAssistantArn(std::forward<AssistantArnT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_assistantArn;
  bool m_assistantArnHasBeenSet = false;
};

}  // namespace Model
}  // namespace LexModelsV2
}  // namespace Aws
