﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/route53profiles/Route53Profiles_EXPORTS.h>
#include <aws/route53profiles/model/ProfileStatus.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Route53Profiles {
namespace Model {

/**
 * <p> The association between a Route 53 Profile and resources. </p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/route53profiles-2018-05-10/ProfileResourceAssociation">AWS
 * API Reference</a></p>
 */
class ProfileResourceAssociation {
 public:
  AWS_ROUTE53PROFILES_API ProfileResourceAssociation() = default;
  AWS_ROUTE53PROFILES_API ProfileResourceAssociation(Aws::Utils::Json::JsonView jsonValue);
  AWS_ROUTE53PROFILES_API ProfileResourceAssociation& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_ROUTE53PROFILES_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p> The date and time that the Profile resource association was created, in Unix
   * time format and Coordinated Universal Time (UTC). </p>
   */
  inline const Aws::Utils::DateTime& GetCreationTime() const { return m_creationTime; }
  inline bool CreationTimeHasBeenSet() const { return m_creationTimeHasBeenSet; }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  void SetCreationTime(CreationTimeT&& value) {
    m_creationTimeHasBeenSet = true;
    m_creationTime = std::forward<CreationTimeT>(value);
  }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  ProfileResourceAssociation& WithCreationTime(CreationTimeT&& value) {
    SetCreationTime(std::forward<CreationTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> ID of the Profile resource association. </p>
   */
  inline const Aws::String& GetId() const { return m_id; }
  inline bool IdHasBeenSet() const { return m_idHasBeenSet; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  ProfileResourceAssociation& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The date and time that the Profile resource association was modified, in
   * Unix time format and Coordinated Universal Time (UTC). </p>
   */
  inline const Aws::Utils::DateTime& GetModificationTime() const { return m_modificationTime; }
  inline bool ModificationTimeHasBeenSet() const { return m_modificationTimeHasBeenSet; }
  template <typename ModificationTimeT = Aws::Utils::DateTime>
  void SetModificationTime(ModificationTimeT&& value) {
    m_modificationTimeHasBeenSet = true;
    m_modificationTime = std::forward<ModificationTimeT>(value);
  }
  template <typename ModificationTimeT = Aws::Utils::DateTime>
  ProfileResourceAssociation& WithModificationTime(ModificationTimeT&& value) {
    SetModificationTime(std::forward<ModificationTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> Name of the Profile resource association. </p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  ProfileResourceAssociation& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> Amazon Web Services account ID of the Profile resource association owner.
   * </p>
   */
  inline const Aws::String& GetOwnerId() const { return m_ownerId; }
  inline bool OwnerIdHasBeenSet() const { return m_ownerIdHasBeenSet; }
  template <typename OwnerIdT = Aws::String>
  void SetOwnerId(OwnerIdT&& value) {
    m_ownerIdHasBeenSet = true;
    m_ownerId = std::forward<OwnerIdT>(value);
  }
  template <typename OwnerIdT = Aws::String>
  ProfileResourceAssociation& WithOwnerId(OwnerIdT&& value) {
    SetOwnerId(std::forward<OwnerIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> Profile ID of the Profile that the resources are associated with. </p>
   */
  inline const Aws::String& GetProfileId() const { return m_profileId; }
  inline bool ProfileIdHasBeenSet() const { return m_profileIdHasBeenSet; }
  template <typename ProfileIdT = Aws::String>
  void SetProfileId(ProfileIdT&& value) {
    m_profileIdHasBeenSet = true;
    m_profileId = std::forward<ProfileIdT>(value);
  }
  template <typename ProfileIdT = Aws::String>
  ProfileResourceAssociation& WithProfileId(ProfileIdT&& value) {
    SetProfileId(std::forward<ProfileIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The Amazon Resource Name (ARN) of the resource association. </p>
   */
  inline const Aws::String& GetResourceArn() const { return m_resourceArn; }
  inline bool ResourceArnHasBeenSet() const { return m_resourceArnHasBeenSet; }
  template <typename ResourceArnT = Aws::String>
  void SetResourceArn(ResourceArnT&& value) {
    m_resourceArnHasBeenSet = true;
    m_resourceArn = std::forward<ResourceArnT>(value);
  }
  template <typename ResourceArnT = Aws::String>
  ProfileResourceAssociation& WithResourceArn(ResourceArnT&& value) {
    SetResourceArn(std::forward<ResourceArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> If the DNS resource is a DNS Firewall rule group, this indicates the
   * priority. </p>
   */
  inline const Aws::String& GetResourceProperties() const { return m_resourceProperties; }
  inline bool ResourcePropertiesHasBeenSet() const { return m_resourcePropertiesHasBeenSet; }
  template <typename ResourcePropertiesT = Aws::String>
  void SetResourceProperties(ResourcePropertiesT&& value) {
    m_resourcePropertiesHasBeenSet = true;
    m_resourceProperties = std::forward<ResourcePropertiesT>(value);
  }
  template <typename ResourcePropertiesT = Aws::String>
  ProfileResourceAssociation& WithResourceProperties(ResourcePropertiesT&& value) {
    SetResourceProperties(std::forward<ResourcePropertiesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> Resource type, such as a private hosted zone, or DNS Firewall rule group.
   * </p>
   */
  inline const Aws::String& GetResourceType() const { return m_resourceType; }
  inline bool ResourceTypeHasBeenSet() const { return m_resourceTypeHasBeenSet; }
  template <typename ResourceTypeT = Aws::String>
  void SetResourceType(ResourceTypeT&& value) {
    m_resourceTypeHasBeenSet = true;
    m_resourceType = std::forward<ResourceTypeT>(value);
  }
  template <typename ResourceTypeT = Aws::String>
  ProfileResourceAssociation& WithResourceType(ResourceTypeT&& value) {
    SetResourceType(std::forward<ResourceTypeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> Status of the Profile resource association. </p>
   */
  inline ProfileStatus GetStatus() const { return m_status; }
  inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
  inline void SetStatus(ProfileStatus value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline ProfileResourceAssociation& WithStatus(ProfileStatus value) {
    SetStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> Additional information about the Profile resource association. </p>
   */
  inline const Aws::String& GetStatusMessage() const { return m_statusMessage; }
  inline bool StatusMessageHasBeenSet() const { return m_statusMessageHasBeenSet; }
  template <typename StatusMessageT = Aws::String>
  void SetStatusMessage(StatusMessageT&& value) {
    m_statusMessageHasBeenSet = true;
    m_statusMessage = std::forward<StatusMessageT>(value);
  }
  template <typename StatusMessageT = Aws::String>
  ProfileResourceAssociation& WithStatusMessage(StatusMessageT&& value) {
    SetStatusMessage(std::forward<StatusMessageT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Utils::DateTime m_creationTime{};

  Aws::String m_id;

  Aws::Utils::DateTime m_modificationTime{};

  Aws::String m_name;

  Aws::String m_ownerId;

  Aws::String m_profileId;

  Aws::String m_resourceArn;

  Aws::String m_resourceProperties;

  Aws::String m_resourceType;

  ProfileStatus m_status{ProfileStatus::NOT_SET};

  Aws::String m_statusMessage;
  bool m_creationTimeHasBeenSet = false;
  bool m_idHasBeenSet = false;
  bool m_modificationTimeHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_ownerIdHasBeenSet = false;
  bool m_profileIdHasBeenSet = false;
  bool m_resourceArnHasBeenSet = false;
  bool m_resourcePropertiesHasBeenSet = false;
  bool m_resourceTypeHasBeenSet = false;
  bool m_statusHasBeenSet = false;
  bool m_statusMessageHasBeenSet = false;
};

}  // namespace Model
}  // namespace Route53Profiles
}  // namespace Aws
