/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.ParameterAnnotationsAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.DescriptorClassEnumeration;
import proguard.classfile.util.InternalTypeEnumeration;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.info.ParameterUsageMarker;

public class MethodDescriptorShrinker
extends SimplifiedVisitor
implements MemberVisitor,
AttributeVisitor {
    private static final boolean DEBUG = false;
    private final MemberVisitor extraMemberVisitor;

    public MethodDescriptorShrinker() {
        this(null);
    }

    public MethodDescriptorShrinker(MemberVisitor extraMemberVisitor) {
        this.extraMemberVisitor = extraMemberVisitor;
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        String descriptor = programMethod.getDescriptor(programClass);
        String newDescriptor = this.shrinkDescriptor(programMethod, descriptor, 0);
        if (!newDescriptor.equals(descriptor)) {
            String name;
            programMethod.attributesAccept(programClass, this);
            String newName = name = programMethod.getName(programClass);
            if (!name.equals("<init>")) {
                newName = newName + '$' + Long.toHexString(Math.abs(descriptor.hashCode()));
            }
            ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor(programClass);
            if (!newName.equals(name)) {
                programMethod.u2nameIndex = constantPoolEditor.addUtf8Constant(newName);
            }
            programMethod.referencedClasses = this.shrinkReferencedClasses(programMethod, descriptor, 0, programMethod.referencedClasses);
            programMethod.u2descriptorIndex = constantPoolEditor.addUtf8Constant(newDescriptor);
            if (this.extraMemberVisitor != null) {
                this.extraMemberVisitor.visitProgramMethod(programClass, programMethod);
            }
        }
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitSignatureAttribute(Clazz clazz, Method method, SignatureAttribute signatureAttribute) {
        int syntheticParametersSize;
        String signature = signatureAttribute.getSignature(clazz);
        String newSignature = this.shrinkDescriptor(method, signature, syntheticParametersSize = new InternalTypeEnumeration(method.getDescriptor(clazz)).typesSize() - new InternalTypeEnumeration(signature).typesSize());
        if (!newSignature.equals(signature)) {
            signatureAttribute.u2signatureIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(newSignature);
            signatureAttribute.referencedClasses = this.shrinkReferencedClasses(method, signature, syntheticParametersSize, signatureAttribute.referencedClasses);
        }
    }

    @Override
    public void visitAnyParameterAnnotationsAttribute(Clazz clazz, Method method, ParameterAnnotationsAttribute parameterAnnotationsAttribute) {
        int[] annotationsCounts = parameterAnnotationsAttribute.u2parameterAnnotationsCount;
        Annotation[][] annotations = parameterAnnotationsAttribute.parameterAnnotations;
        String descriptor = method.getDescriptor(clazz);
        int syntheticParameterCount = new InternalTypeEnumeration(descriptor).typeCount() - parameterAnnotationsAttribute.u1parametersCount;
        int syntheticParametersSize = ClassUtil.internalMethodVariableIndex(descriptor, true, syntheticParameterCount);
        int parameterIndex = syntheticParametersSize + ((method.getAccessFlags() & 8) != 0 ? 0 : 1);
        int annotationIndex = 0;
        int newAnnotationIndex = 0;
        InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(descriptor);
        for (int counter = 0; counter < syntheticParameterCount; ++counter) {
            internalTypeEnumeration.nextType();
        }
        while (internalTypeEnumeration.hasMoreTypes()) {
            String type = internalTypeEnumeration.nextType();
            if (ParameterUsageMarker.isParameterUsed(method, parameterIndex)) {
                annotationsCounts[newAnnotationIndex] = annotationsCounts[annotationIndex];
                annotations[newAnnotationIndex++] = annotations[annotationIndex];
            }
            ++annotationIndex;
            parameterIndex += ClassUtil.internalTypeSize(type);
        }
        parameterAnnotationsAttribute.u1parametersCount = newAnnotationIndex;
        while (newAnnotationIndex < annotationIndex) {
            annotationsCounts[newAnnotationIndex] = 0;
            annotations[newAnnotationIndex++] = null;
        }
    }

    private String shrinkDescriptor(Method method, String descriptor, int syntheticParametersSize) {
        int parameterIndex = syntheticParametersSize + ((method.getAccessFlags() & 8) != 0 ? 0 : 1);
        InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(descriptor);
        StringBuffer newDescriptorBuffer = new StringBuffer(descriptor.length());
        newDescriptorBuffer.append(internalTypeEnumeration.formalTypeParameters());
        newDescriptorBuffer.append('(');
        while (internalTypeEnumeration.hasMoreTypes()) {
            String type = internalTypeEnumeration.nextType();
            if (ParameterUsageMarker.isParameterUsed(method, parameterIndex)) {
                newDescriptorBuffer.append(type);
            }
            parameterIndex += ClassUtil.internalTypeSize(type);
        }
        newDescriptorBuffer.append(')');
        newDescriptorBuffer.append(internalTypeEnumeration.returnType());
        return newDescriptorBuffer.toString();
    }

    private Clazz[] shrinkReferencedClasses(Method method, String descriptor, int syntheticParametersSize, Clazz[] referencedClasses) {
        if (referencedClasses != null) {
            int counter;
            int parameterIndex = syntheticParametersSize + ((method.getAccessFlags() & 8) != 0 ? 0 : 1);
            InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(descriptor);
            int referencedClassIndex = 0;
            int newReferencedClassIndex = 0;
            String type = internalTypeEnumeration.formalTypeParameters();
            int count = new DescriptorClassEnumeration(type).classCount();
            for (counter = 0; counter < count; ++counter) {
                referencedClasses[newReferencedClassIndex++] = referencedClasses[referencedClassIndex++];
            }
            while (internalTypeEnumeration.hasMoreTypes()) {
                type = internalTypeEnumeration.nextType();
                count = new DescriptorClassEnumeration(type).classCount();
                if (ParameterUsageMarker.isParameterUsed(method, parameterIndex)) {
                    for (counter = 0; counter < count; ++counter) {
                        referencedClasses[newReferencedClassIndex++] = referencedClasses[referencedClassIndex++];
                    }
                } else {
                    referencedClassIndex += count;
                }
                parameterIndex += ClassUtil.internalTypeSize(type);
            }
            type = internalTypeEnumeration.returnType();
            count = new DescriptorClassEnumeration(type).classCount();
            for (counter = 0; counter < count; ++counter) {
                referencedClasses[newReferencedClassIndex++] = referencedClasses[referencedClassIndex++];
            }
            if (newReferencedClassIndex == 0) {
                referencedClasses = null;
            } else if (newReferencedClassIndex < referencedClassIndex) {
                Clazz[] newReferencedClasses = new Clazz[newReferencedClassIndex];
                System.arraycopy(referencedClasses, 0, newReferencedClasses, 0, newReferencedClassIndex);
                referencedClasses = newReferencedClasses;
            }
        }
        return referencedClasses;
    }
}

