/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.DoubleConstant;
import proguard.classfile.constant.FloatConstant;
import proguard.classfile.constant.IntegerConstant;
import proguard.classfile.constant.LongConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.ConstantAdder;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.LookUpSwitchInstruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.TableSwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.InstructionSequenceMatcher;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.optimize.peephole.BranchTargetFinder;

public class InstructionSequenceReplacer
extends SimplifiedVisitor
implements InstructionVisitor,
ConstantVisitor {
    private static final boolean DEBUG = false;
    public static final int X = 0x40000000;
    public static final int Y = 0x40000001;
    public static final int Z = 0x40000002;
    public static final int A = 0x40000003;
    public static final int B = 0x40000004;
    public static final int C = 0x40000005;
    public static final int D = 0x40000006;
    public static final int E = 0x40000007;
    public static final int F = 0x40000008;
    public static final int G = 0x40000009;
    public static final int H = 0x4000000A;
    public static final int I = 0x4000000B;
    public static final int J = 0x4000000C;
    public static final int K = 0x4000000D;
    public static final int L = 0x4000000E;
    public static final int M = 0x4000000F;
    public static final int N = 0x40000010;
    public static final int O = 0x40000011;
    public static final int P = 1073741842;
    public static final int Q = 1073741843;
    public static final int R = 0x40000014;
    private static final int LABEL_FLAG = 0x20000000;
    private static final int BOOLEAN_STRING = 1;
    private static final int CHAR_STRING = 2;
    private static final int INT_STRING = 3;
    private static final int LONG_STRING = 4;
    private static final int FLOAT_STRING = 5;
    private static final int DOUBLE_STRING = 6;
    private static final int STRING_STRING = 7;
    public static final int STRING_A_LENGTH = 0x20000000;
    public static final int BOOLEAN_A_STRING = 0x20000001;
    public static final int CHAR_A_STRING = 0x20000002;
    public static final int INT_A_STRING = 0x20000003;
    public static final int LONG_A_STRING = 0x20000004;
    public static final int FLOAT_A_STRING = 0x20000005;
    public static final int DOUBLE_A_STRING = 0x20000006;
    public static final int STRING_A_STRING = 0x20000007;
    public static final int BOOLEAN_B_STRING = 0x20000010;
    public static final int CHAR_B_STRING = 0x20000020;
    public static final int INT_B_STRING = 0x20000030;
    public static final int LONG_B_STRING = 0x20000040;
    public static final int FLOAT_B_STRING = 0x20000050;
    public static final int DOUBLE_B_STRING = 0x20000060;
    public static final int STRING_B_STRING = 0x20000070;
    private static int labelCounter;
    private final InstructionSequenceMatcher instructionSequenceMatcher;
    private final Constant[] patternConstants;
    private final Instruction[] replacementInstructions;
    private final BranchTargetFinder branchTargetFinder;
    private final CodeAttributeEditor codeAttributeEditor;
    private final InstructionVisitor extraInstructionVisitor;
    private final MyReplacementInstructionFactory replacementInstructionFactory = new MyReplacementInstructionFactory();

    public InstructionSequenceReplacer(Constant[] patternConstants, Instruction[] patternInstructions, Constant[] replacementConstants, Instruction[] replacementInstructions, BranchTargetFinder branchTargetFinder, CodeAttributeEditor codeAttributeEditor) {
        this(patternConstants, patternInstructions, replacementConstants, replacementInstructions, branchTargetFinder, codeAttributeEditor, null);
    }

    public InstructionSequenceReplacer(Constant[] patternConstants, Instruction[] patternInstructions, Constant[] replacementConstants, Instruction[] replacementInstructions, BranchTargetFinder branchTargetFinder, CodeAttributeEditor codeAttributeEditor, InstructionVisitor extraInstructionVisitor) {
        this(new InstructionSequenceMatcher(patternConstants, patternInstructions), patternConstants, patternInstructions, replacementConstants, replacementInstructions, branchTargetFinder, codeAttributeEditor, extraInstructionVisitor);
    }

    protected InstructionSequenceReplacer(InstructionSequenceMatcher instructionSequenceMatcher, Constant[] patternConstants, Instruction[] patternInstructions, Constant[] replacementConstants, Instruction[] replacementInstructions, BranchTargetFinder branchTargetFinder, CodeAttributeEditor codeAttributeEditor, InstructionVisitor extraInstructionVisitor) {
        this.instructionSequenceMatcher = instructionSequenceMatcher;
        this.patternConstants = patternConstants;
        this.replacementInstructions = replacementInstructions;
        this.branchTargetFinder = branchTargetFinder;
        this.codeAttributeEditor = codeAttributeEditor;
        this.extraInstructionVisitor = extraInstructionVisitor;
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
        if (this.branchTargetFinder != null && this.branchTargetFinder.isTarget(offset) || this.codeAttributeEditor.isModified(offset)) {
            this.instructionSequenceMatcher.reset();
        }
        instruction.accept(clazz, method, codeAttribute, offset, this.instructionSequenceMatcher);
        if (this.instructionSequenceMatcher.isMatching() && this.matchedInstructionsUnmodified()) {
            int replacementCount = this.replacementInstructions.length;
            int patternCount = this.instructionSequenceMatcher.instructionCount();
            if (replacementCount <= patternCount) {
                int index;
                for (index = 0; index < replacementCount; ++index) {
                    this.codeAttributeEditor.replaceInstruction(this.instructionSequenceMatcher.matchedInstructionOffset(index), this.replacementInstructionFactory.create(clazz, codeAttribute, index));
                }
                for (index = replacementCount; index < patternCount; ++index) {
                    this.codeAttributeEditor.deleteInstruction(this.instructionSequenceMatcher.matchedInstructionOffset(index));
                }
            } else {
                for (int index = 0; index < patternCount; ++index) {
                    this.codeAttributeEditor.replaceInstruction(this.instructionSequenceMatcher.matchedInstructionOffset(index), this.replacementInstructionFactory.create(clazz, codeAttribute, index));
                }
                Instruction[] extraInstructions = new Instruction[replacementCount - patternCount];
                for (int index = 0; index < extraInstructions.length; ++index) {
                    extraInstructions[index] = this.replacementInstructionFactory.create(clazz, codeAttribute, patternCount + index);
                }
                this.codeAttributeEditor.insertAfterInstruction(this.instructionSequenceMatcher.matchedInstructionOffset(patternCount - 1), extraInstructions);
            }
            if (this.extraInstructionVisitor != null) {
                instruction.accept(clazz, method, codeAttribute, offset, this.extraInstructionVisitor);
            }
        }
    }

    private boolean matchedInstructionsUnmodified() {
        for (int index = 0; index < this.instructionSequenceMatcher.instructionCount(); ++index) {
            if (!this.codeAttributeEditor.isModified(this.instructionSequenceMatcher.matchedInstructionOffset(index))) continue;
            return false;
        }
        return true;
    }

    protected int matchedArgument(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, int argument) {
        return this.matchedArgument(clazz, argument);
    }

    protected int matchedArgument(Clazz clazz, int argument) {
        if (argument == 0x20000000) {
            return clazz.getStringString(this.instructionSequenceMatcher.matchedArgument(0x40000003)).length();
        }
        return this.instructionSequenceMatcher.matchedArgument(argument);
    }

    protected int matchedConstantIndex(ProgramClass programClass, int constantIndex) {
        if (constantIndex >= 0x20000001 && constantIndex <= 0x20000077) {
            return new ConstantPoolEditor(programClass).addStringConstant(this.argumentAsString(programClass, constantIndex & 0xF, 0x40000003) + this.argumentAsString(programClass, constantIndex >>> 4 & 0xF, 0x40000004), null, null);
        }
        int matchedConstantIndex = this.instructionSequenceMatcher.matchedConstantIndex(constantIndex);
        if (matchedConstantIndex > 0) {
            return matchedConstantIndex;
        }
        ProgramClass dummyClass = new ProgramClass();
        dummyClass.constantPool = this.patternConstants;
        return new ConstantAdder(programClass).addConstant((Clazz)dummyClass, constantIndex);
    }

    protected int matchedBranchOffset(int offset, int branchOffset) {
        if (InstructionSequenceReplacer.isLabel(branchOffset)) {
            return this.uniqueLabel(branchOffset);
        }
        return this.instructionSequenceMatcher.matchedBranchOffset(offset, branchOffset);
    }

    protected int[] matchedJumpOffsets(int offset, int[] jumpOffsets) {
        for (int index = 0; index < jumpOffsets.length; ++index) {
            if (!InstructionSequenceReplacer.isLabel(jumpOffsets[index])) continue;
            jumpOffsets[index] = this.uniqueLabel(jumpOffsets[index]);
        }
        return this.instructionSequenceMatcher.matchedJumpOffsets(offset, jumpOffsets);
    }

    private String argumentAsString(ProgramClass programClass, int valueType, int argument) {
        switch (valueType) {
            case 1: {
                return Boolean.toString((this.wasConstant(argument) ? ((IntegerConstant)this.matchedConstant(programClass, argument)).getValue() : this.matchedArgument(argument)) != 0);
            }
            case 2: {
                return Character.toString((char)(this.wasConstant(argument) ? ((IntegerConstant)this.matchedConstant(programClass, argument)).getValue() : this.matchedArgument(argument)));
            }
            case 3: {
                return Integer.toString(this.wasConstant(argument) ? ((IntegerConstant)this.matchedConstant(programClass, argument)).getValue() : this.matchedArgument(argument));
            }
            case 4: {
                return Long.toString(this.wasConstant(argument) ? ((LongConstant)this.matchedConstant(programClass, argument)).getValue() : (long)this.matchedArgument(argument));
            }
            case 5: {
                return Float.toString(this.wasConstant(argument) ? ((FloatConstant)this.matchedConstant(programClass, argument)).getValue() : (float)this.matchedArgument(argument));
            }
            case 6: {
                return Double.toString(this.wasConstant(argument) ? ((DoubleConstant)this.matchedConstant(programClass, argument)).getValue() : (double)this.matchedArgument(argument));
            }
            case 7: {
                return programClass.getStringString(this.instructionSequenceMatcher.matchedConstantIndex(argument));
            }
        }
        return "";
    }

    protected InstructionSequenceMatcher getInstructionSequenceMatcher() {
        return this.instructionSequenceMatcher;
    }

    protected boolean wasConstant(int argument) {
        return this.instructionSequenceMatcher.wasConstant(argument);
    }

    protected Constant matchedConstant(ProgramClass programClass, int argument) {
        return programClass.getConstant(this.instructionSequenceMatcher.matchedConstantIndex(argument));
    }

    protected int matchedArgument(int argument) {
        return this.instructionSequenceMatcher.matchedArgument(argument);
    }

    private int uniqueLabel(int labelIdentifier) {
        return labelIdentifier | this.instructionSequenceMatcher.matchedInstructionOffset(0) << 8;
    }

    public static Label label() {
        return new Label(labelCounter++);
    }

    public static Label catch_(int startOffset, int endOffset, int catchType) {
        return new Catch(labelCounter++, startOffset, endOffset, catchType);
    }

    private static boolean isLabel(int instructionOffset) {
        return (instructionOffset & 0xFF000000) == 0x20000000;
    }

    private static class Catch
    extends Label {
        private final int startOfffset;
        private final int endOffset;
        private final int catchType;

        private Catch(int identifier, int startOffset, int endOffset, int catchType) {
            super(identifier);
            this.startOfffset = startOffset;
            this.endOffset = endOffset;
            this.catchType = catchType;
        }

        @Override
        public Instruction shrink() {
            return this;
        }

        @Override
        public void write(byte[] code, int offset) {
        }

        @Override
        protected void readInfo(byte[] code, int offset) {
            throw new UnsupportedOperationException("Can't read catch instruction");
        }

        @Override
        protected void writeInfo(byte[] code, int offset) {
            throw new UnsupportedOperationException("Can't write catch instruction");
        }

        @Override
        public int length(int offset) {
            return super.length(offset);
        }

        @Override
        public void accept(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, InstructionVisitor instructionVisitor) {
            MyReplacementInstructionFactory replacementInstructionFactory = (MyReplacementInstructionFactory)instructionVisitor;
            replacementInstructionFactory.visitCatchInstruction(clazz, method, codeAttribute, offset, this);
        }

        @Override
        public String toString() {
            return "catch " + (InstructionSequenceReplacer.isLabel(this.startOfffset) ? "label_" : "") + this.startOfffset + ", " + (InstructionSequenceReplacer.isLabel(this.endOffset) ? "label_" : "") + this.endOffset + ", #" + this.catchType;
        }
    }

    public static class Label
    extends Instruction {
        protected final int identifier;

        private Label(int identifier) {
            this.identifier = identifier;
        }

        public int offset() {
            return 0x20000000 | this.identifier;
        }

        @Override
        public Instruction shrink() {
            return this;
        }

        @Override
        public void write(byte[] code, int offset) {
        }

        @Override
        protected void readInfo(byte[] code, int offset) {
            throw new UnsupportedOperationException("Can't read label instruction");
        }

        @Override
        protected void writeInfo(byte[] code, int offset) {
            throw new UnsupportedOperationException("Can't write label instruction");
        }

        @Override
        public int length(int offset) {
            return 0;
        }

        @Override
        public void accept(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, InstructionVisitor instructionVisitor) {
            MyReplacementInstructionFactory replacementInstructionFactory = (MyReplacementInstructionFactory)instructionVisitor;
            replacementInstructionFactory.visitLabelInstruction(clazz, method, codeAttribute, offset, this);
        }

        public String toString() {
            return "label_" + this.offset();
        }
    }

    private class MyReplacementInstructionFactory
    implements InstructionVisitor {
        private Instruction replacementInstruction;

        private MyReplacementInstructionFactory() {
        }

        public Instruction create(Clazz clazz, CodeAttribute codeAttribute, int index) {
            int matchedInstructionIndex = index < InstructionSequenceReplacer.this.instructionSequenceMatcher.instructionCount() ? index : InstructionSequenceReplacer.this.instructionSequenceMatcher.instructionCount() - 1;
            int matchedInstructionOffset = InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedInstructionOffset(matchedInstructionIndex);
            InstructionSequenceReplacer.this.replacementInstructions[index].accept(clazz, null, codeAttribute, matchedInstructionOffset, this);
            return this.replacementInstruction;
        }

        @Override
        public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SimpleInstruction simpleInstruction) {
            this.replacementInstruction = new SimpleInstruction(simpleInstruction.opcode, InstructionSequenceReplacer.this.matchedArgument(clazz, method, codeAttribute, offset, simpleInstruction.constant));
        }

        @Override
        public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VariableInstruction variableInstruction) {
            this.replacementInstruction = new VariableInstruction(variableInstruction.opcode, InstructionSequenceReplacer.this.matchedArgument(clazz, method, codeAttribute, offset, variableInstruction.variableIndex), InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedArgument(variableInstruction.constant));
        }

        @Override
        public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
            this.replacementInstruction = new ConstantInstruction(constantInstruction.opcode, InstructionSequenceReplacer.this.matchedConstantIndex((ProgramClass)clazz, constantInstruction.constantIndex), InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedArgument(constantInstruction.constant));
        }

        @Override
        public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, BranchInstruction branchInstruction) {
            this.replacementInstruction = new BranchInstruction(branchInstruction.opcode, InstructionSequenceReplacer.this.matchedBranchOffset(offset, branchInstruction.branchOffset));
        }

        @Override
        public void visitTableSwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, TableSwitchInstruction tableSwitchInstruction) {
            this.replacementInstruction = new TableSwitchInstruction(tableSwitchInstruction.opcode, InstructionSequenceReplacer.this.matchedBranchOffset(offset, tableSwitchInstruction.defaultOffset), InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedArgument(tableSwitchInstruction.lowCase), InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedArgument(tableSwitchInstruction.highCase), InstructionSequenceReplacer.this.matchedJumpOffsets(offset, tableSwitchInstruction.jumpOffsets));
        }

        @Override
        public void visitLookUpSwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, LookUpSwitchInstruction lookUpSwitchInstruction) {
            this.replacementInstruction = new LookUpSwitchInstruction(lookUpSwitchInstruction.opcode, InstructionSequenceReplacer.this.matchedBranchOffset(offset, lookUpSwitchInstruction.defaultOffset), InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedArguments(lookUpSwitchInstruction.cases), InstructionSequenceReplacer.this.matchedJumpOffsets(offset, lookUpSwitchInstruction.jumpOffsets));
        }

        public void visitLabelInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Label label) {
            this.replacementInstruction = InstructionSequenceReplacer.this.codeAttributeEditor.label(InstructionSequenceReplacer.this.uniqueLabel(label.identifier));
        }

        public void visitCatchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Catch catch_) {
            this.replacementInstruction = InstructionSequenceReplacer.this.codeAttributeEditor.catch_(InstructionSequenceReplacer.this.uniqueLabel(catch_.identifier), InstructionSequenceReplacer.this.uniqueLabel(catch_.startOfffset), InstructionSequenceReplacer.this.uniqueLabel(catch_.endOffset), InstructionSequenceReplacer.this.matchedConstantIndex((ProgramClass)clazz, catch_.catchType));
        }
    }
}

