/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.lang.conditions;

import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ConditionEvent;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.conditions.AndCondition;
import com.tngtech.archunit.lang.conditions.JoinCondition;
import com.tngtech.archunit.thirdparty.com.google.common.base.Joiner;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;

class OrCondition<T>
extends JoinCondition<T> {
    OrCondition(ArchCondition<T> first, ArchCondition<T> second) {
        super("or", ImmutableList.of(first, second));
    }

    @Override
    public void check(T item, ConditionEvents events) {
        events.add(new OrConditionEvent<T>(item, this.evaluateConditions(item)));
    }

    static class OrConditionEvent<T>
    extends JoinCondition.JoinConditionEvent<T> {
        OrConditionEvent(T item, List<JoinCondition.ConditionWithEvents<T>> evaluatedConditions) {
            super(item, evaluatedConditions);
        }

        @Override
        public boolean isViolation() {
            return this.evaluatedConditions.stream().allMatch(evaluation -> evaluation.getEvents().containViolation());
        }

        @Override
        public ConditionEvent invert() {
            return new AndCondition.AndConditionEvent<Object>(this.correspondingObject, this.invert(this.evaluatedConditions));
        }

        @Override
        public List<String> getDescriptionLines() {
            return ImmutableList.of(this.createMessage());
        }

        private String createMessage() {
            return Joiner.on(" and ").join(this.getUniqueLinesOfViolations());
        }

        @Override
        public void handleWith(ConditionEvent.Handler handler) {
            handler.handle(Collections.singleton(this.correspondingObject), this.createMessage());
        }
    }
}

