/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value.css;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.echosvg.css.engine.CSSContext;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.StyleMap;
import io.sf.carte.echosvg.css.engine.value.IdentifierManager;
import io.sf.carte.echosvg.css.engine.value.StringMap;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueConstants;
import org.w3c.dom.DOMException;

public class FontWeightManager
extends IdentifierManager {
    protected static final StringMap<Value> values = new StringMap(7);

    @Override
    public boolean isInheritedProperty() {
        return true;
    }

    @Override
    public boolean isAnimatableProperty() {
        return true;
    }

    @Override
    public boolean isAdditiveProperty() {
        return false;
    }

    @Override
    public int getPropertyType() {
        return 28;
    }

    @Override
    public String getPropertyName() {
        return "font-weight";
    }

    @Override
    public Value getDefaultValue() {
        return ValueConstants.NORMAL_VALUE;
    }

    @Override
    public Value createValue(LexicalUnit lu, CSSEngine engine) throws DOMException {
        if (lu.getLexicalUnitType() == LexicalUnit.LexicalType.INTEGER) {
            int i = lu.getIntegerValue();
            switch (i) {
                case 100: {
                    return ValueConstants.NUMBER_100;
                }
                case 200: {
                    return ValueConstants.NUMBER_200;
                }
                case 300: {
                    return ValueConstants.NUMBER_300;
                }
                case 400: {
                    return ValueConstants.NUMBER_400;
                }
                case 500: {
                    return ValueConstants.NUMBER_500;
                }
                case 600: {
                    return ValueConstants.NUMBER_600;
                }
                case 700: {
                    return ValueConstants.NUMBER_700;
                }
                case 800: {
                    return ValueConstants.NUMBER_800;
                }
                case 900: {
                    return ValueConstants.NUMBER_900;
                }
            }
            throw this.createInvalidFloatValueDOMException(i);
        }
        return super.createValue(lu, engine);
    }

    @Override
    public Value computeValue(CSSStylableElement elt, String pseudo, CSSEngine engine, int idx, StyleMap sm, Value value) {
        if (value != null && value.getPrimitiveType() == CSSValue.Type.IDENT) {
            if (value.getIdentifierValue() == "bolder") {
                float fw;
                sm.putParentRelative(idx, true);
                CSSContext ctx = engine.getCSSContext();
                CSSStylableElement p = CSSEngine.getParentCSSStylableElement(elt);
                if (p == null) {
                    fw = 400.0f;
                } else {
                    Value v = engine.getComputedStyle(p, pseudo, idx);
                    fw = this.lengthValue(v);
                }
                return this.createFontWeight(ctx.getBolderFontWeight(fw));
            }
            if (value.getIdentifierValue() == "lighter") {
                float fw;
                sm.putParentRelative(idx, true);
                CSSContext ctx = engine.getCSSContext();
                CSSStylableElement p = CSSEngine.getParentCSSStylableElement(elt);
                if (p == null) {
                    fw = 400.0f;
                } else {
                    Value v = engine.getComputedStyle(p, pseudo, idx);
                    fw = this.lengthValue(v);
                }
                return this.createFontWeight(ctx.getLighterFontWeight(fw));
            }
            if (value.getIdentifierValue() == "normal") {
                return ValueConstants.NUMBER_400;
            }
            if (value.getIdentifierValue() == "bold") {
                return ValueConstants.NUMBER_700;
            }
        }
        return value;
    }

    protected Value createFontWeight(float f) {
        switch ((int)f) {
            case 100: {
                return ValueConstants.NUMBER_100;
            }
            case 200: {
                return ValueConstants.NUMBER_200;
            }
            case 300: {
                return ValueConstants.NUMBER_300;
            }
            case 400: {
                return ValueConstants.NUMBER_400;
            }
            case 500: {
                return ValueConstants.NUMBER_500;
            }
            case 600: {
                return ValueConstants.NUMBER_600;
            }
            case 700: {
                return ValueConstants.NUMBER_700;
            }
            case 800: {
                return ValueConstants.NUMBER_800;
            }
        }
        return ValueConstants.NUMBER_900;
    }

    @Override
    public StringMap<Value> getIdentifiers() {
        return values;
    }

    static {
        values.put("all", ValueConstants.ALL_VALUE);
        values.put("bold", ValueConstants.BOLD_VALUE);
        values.put("bolder", ValueConstants.BOLDER_VALUE);
        values.put("lighter", ValueConstants.LIGHTER_VALUE);
        values.put("normal", ValueConstants.NORMAL_VALUE);
    }
}

