---
stage: Security Risk Management
group: Security Policies
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'チュートリアル: スキャン実行ポリシーをセットアップする'
---

{{< details >}}

- プラン: Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

このチュートリアルでは、[スキャン実行ポリシー](../../user/application_security/policies/scan_execution_policies.md)を作成して適用する方法を説明します。これらのポリシーは、CI/CDパイプラインの一部としてアプリケーションセキュリティツールを適用します。このチュートリアルでは、2つのプロジェクトのCI/CDパイプラインでシークレット検出を適用するポリシーを作成します。

このチュートリアルでは、次のことを行います:

- [プロジェクトAを作成](#create-project-a)。
- [スキャン実行ポリシーを作成](#create-the-scan-execution-policy)。
- [プロジェクトAでスキャン実行ポリシーをテスト](#test-the-scan-execution-policy-with-project-a)。
- [プロジェクトBを作成](#create-project-b)。
- [プロジェクトBをセキュリティポリシープロジェクトにリンク](#link-project-b-to-the-security-policy-project)。
- [プロジェクトBでスキャン実行ポリシーをテスト](#test-the-scan-execution-policy-with-project-b)。

## はじめる前 {#before-you-begin}

- 既存のグループに新しいプロジェクトを作成するための権限が必要です。

## プロジェクトAを作成 {#create-project-a}

標準的なワークフローでは、既存のプロジェクトが既にある場合があります。このチュートリアルでは、何もない状態から始めるため、最初のステップはプロジェクトを作成することです。

プロジェクトAを作成するには、次の手順を実行します:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。
1. **新規プロジェクト**を選択します。
1. **空のプロジェクトの作成**を選択します。
1. フィールドに入力します。**プロジェクト名**に、`go-example-a`と入力します。
1. **プロジェクトを作成**を選択します。
1. **Add (`+`)**（追加） > **新しいファイル**を選択します。
1. ファイル名に`helloworld.go`と入力します。
1. 次のGoのコード例をコピーしてファイルに貼り付けます。

   ```go
   package main
   import "fmt"
   func main() {
       fmt.Println("Hello world")
   }
   ```

1. **変更をコミットする**を選択します。

次の手順は、スキャン実行ポリシーを作成することです。最初のセキュリティポリシーを作成すると、ポリシープロジェクトが作成されます。ポリシープロジェクトには、リンクされているすべてのプロジェクトで作成されたセキュリティポリシーが保存されます。ポリシーを保護対象のプロジェクトから分離しておくことで、セキュリティの設定を再利用しやすく、メンテナンスも容易になります。

## スキャン実行ポリシーを作成 {#create-the-scan-execution-policy}

スキャン実行ポリシーを作成するには、次の手順を実行します:

1. 左側のサイドバーで**検索または移動先**を選択し、`go-example-a`プロジェクトを検索します。
1. **セキュリティ** > **ポリシー**に移動します。
1. **新規ポリシー**を選択します。
1. **スキャン実行ポリシー**セクションで、**ポリシーの選択**を選択します。
1. フィールドに入力します。
   - **名前**: シークレット検出を適用します。
   - **ポリシーステータス**: 有効。
   - **アクション**: シークレット検出スキャンを実行します。
   - **条件**: すべてのブランチで、パイプラインが実行されるたびにトリガーされます。
1. **マージリクエスト経由で設定**を選択します。

   ポリシープロジェクト`go-example-a - Security project`が作成され、マージリクエストが作成されます。

1. オプション。マージリクエストの**変更**タブで、生成されたポリシーYAMLを確認します。
1. **概要**タブに移動し、**マージ**を選択します。
1. 左側のサイドバーで**検索または移動先**を選択し、`go-example-a`プロジェクトを検索します。
1. **セキュリティ** > **ポリシー**に移動します。

これで、すべてのマージリクエストのすべてのブランチでシークレット検出スキャンを実行するスキャン実行ポリシーが作成されました。プロジェクトAでマージリクエストを作成して、ポリシーをテストします。

## プロジェクトAでスキャン実行ポリシーをテスト {#test-the-scan-execution-policy-with-project-a}

スキャン実行ポリシーをテストするには、次の手順を実行します:

1. 左側のサイドバーで、**検索または移動先**を選択して、`go-example-a`という名前のプロジェクトを見つけます。
1. **コード** > **リポジトリ**に移動します。
1. `helloworld.go`ファイルを選択します。
1. **編集** > **単一のファイルを編集**を選択します。
1. `fmt.Println("hello world")`行の直後に次の行を追加します:

   ```plaintext
   var GitLabFeedToken = "feed_token=eFLISqaBym4EjAefkl58"
   ```

1. **Target Branch**（ターゲットブランチ）フィールドに、`feature-a`と入力します。
1. **変更をコミットする**を選択します。
1. マージリクエストページが開いたら、**マージリクエストを作成**を選択します。

   スキャン実行ポリシーが機能するかどうかを確認しましょう。シークレット検出がすべてのブランチで、パイプラインが実行されるたびに実行されるように指定したことを覚えておいてください。

1. 作成したばかりのマージリクエストで、**パイプライン**タブに移動し、作成したパイプラインを選択します。

   ここでは、シークレット検出ジョブが実行されたことがわかります。テストシークレットが検出されたかどうかを確認しましょう。

1. シークレット検出ジョブを選択します。

   ジョブのログの下部付近にある次の出力は、シークレットの例が検出されたことを確認します。

   ```plaintext
   [INFO] [secrets] [2023-09-04T03:46:36Z] ▶ 3:46AM INF 1 commits scanned.
   [INFO] [secrets] [2023-09-04T03:46:36Z] ▶ 3:46AM INF scan completed in 60ms
   [INFO] [secrets] [2023-09-04T03:46:36Z] ▶ 3:46AM WRN leaks found: 1
   ```

1つのプロジェクトでのポリシーの動作を確認しました。別のプロジェクトを作成し、同じポリシーを適用します。

## プロジェクトBを作成 {#create-project-b}

プロジェクトBを作成するには、次の手順を実行します:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。
1. **新規プロジェクト**を選択します。
1. **空のプロジェクトの作成**を選択します。
1. フィールドに入力します。**プロジェクト名**に、`go-example-b`と入力します。
1. **プロジェクトを作成**を選択します。
1. **Add (`+`)**（追加） > **新しいファイル**を選択します。
1. ファイル名に`helloworld.go`と入力します。
1. 次のGoのコード例をコピーしてファイルに貼り付けます。

   ```go
   package main
   import "fmt"
   func main() {
       fmt.Println("Hello world")
   }
   ```

1. **変更をコミットする**を選択します。

これで別のプロジェクトができたので、それを同じポリシープロジェクトにリンクします。

## プロジェクトBをセキュリティポリシープロジェクトにリンク {#link-project-b-to-the-security-policy-project}

プロジェクトBをセキュリティポリシープロジェクトにリンクするには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、`go-example-b`プロジェクトを見つけます。
1. **セキュリティ** > **ポリシー**に移動します。
1. **ポリシープロジェクトを編集**を選択します。
1. ドロップダウンリストを選択し、このチュートリアルの開始時に作成されたセキュリティポリシープロジェクトを検索します。
1. **保存**を選択します。

プロジェクトBを同じポリシープロジェクトにリンクすると、同じポリシーが適用されます。スキャン実行ポリシーは、すべてのブランチで、すべてのマージリクエストでシークレット検出スキャンを実行します。プロジェクトBでマージリクエストを作成して、ポリシーをテストしましょう。

## プロジェクトBでスキャン実行ポリシーをテスト {#test-the-scan-execution-policy-with-project-b}

スキャン実行ポリシーをテストするには、次の手順を実行します:

1. 左側のサイドバーで、**検索または移動先**を選択して、`go-example-b`プロジェクトを見つけます。
1. **コード** > **リポジトリ**に移動します。
1. `helloworld.go`ファイルを選択します。
1. **編集** > **単一のファイルを編集**を選択します。
1. `fmt.Println("hello world")`行の直後に次の行を追加します:

   ```plaintext
   var AdobeClient = "4ab4b080d9ce4072a6be2629c399d653"
   ```

1. **Target Branch**（ターゲットブランチ）フィールドに、`feature-b`と入力します。
1. **変更をコミットする**を選択します。
1. マージリクエストページが開いたら、**マージリクエストを作成**を選択します。

   スキャン実行ポリシーが機能するかどうかを確認しましょう。シークレット検出がすべてのブランチで、パイプラインが実行されるたびに実行されるように指定したことを覚えておいてください。

1. 作成したばかりのマージリクエストで、**パイプライン**タブに移動し、作成したパイプラインを選択します。

1. 作成したばかりのマージリクエストで、パイプラインのIDを選択します。

   ここでは、シークレット検出ジョブが実行されたことがわかります。テストシークレットが検出されたかどうかを確認しましょう。

1. シークレット検出ジョブを選択します。

   ジョブのログの下部付近にある次の出力は、シークレットの例が検出されたことを確認します。

   ```plaintext
   [INFO] [secrets] [2023-09-04T04:22:28Z] ▶ 4:22AM INF 1 commits scanned.
   [INFO] [secrets] [2023-09-04T04:22:28Z] ▶ 4:22AM INF scan completed in 58.2ms
   [INFO] [secrets] [2023-09-04T04:22:28Z] ▶ 4:22AM WRN leaks found: 1
   ```

おつかれさまでした。スキャン実行ポリシーを作成し、プロジェクトに適用する方法を学習しました。
