/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.request.search.query;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.inject.Singleton;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.protobufs.QueryContainer;
import org.opensearch.transport.grpc.proto.request.search.query.BoolQueryBuilderProtoConverter;
import org.opensearch.transport.grpc.proto.request.search.query.ExistsQueryBuilderProtoConverter;
import org.opensearch.transport.grpc.proto.request.search.query.GeoBoundingBoxQueryBuilderProtoConverter;
import org.opensearch.transport.grpc.proto.request.search.query.GeoDistanceQueryBuilderProtoConverter;
import org.opensearch.transport.grpc.proto.request.search.query.IdsQueryBuilderProtoConverter;
import org.opensearch.transport.grpc.proto.request.search.query.MatchAllQueryBuilderProtoConverter;
import org.opensearch.transport.grpc.proto.request.search.query.MatchNoneQueryBuilderProtoConverter;
import org.opensearch.transport.grpc.proto.request.search.query.MatchPhraseQueryBuilderProtoConverter;
import org.opensearch.transport.grpc.proto.request.search.query.MultiMatchQueryBuilderProtoConverter;
import org.opensearch.transport.grpc.proto.request.search.query.NestedQueryBuilderProtoConverter;
import org.opensearch.transport.grpc.proto.request.search.query.QueryBuilderProtoConverterSpiRegistry;
import org.opensearch.transport.grpc.proto.request.search.query.RangeQueryBuilderProtoConverter;
import org.opensearch.transport.grpc.proto.request.search.query.RegexpQueryBuilderProtoConverter;
import org.opensearch.transport.grpc.proto.request.search.query.ScriptQueryBuilderProtoConverter;
import org.opensearch.transport.grpc.proto.request.search.query.TermQueryBuilderProtoConverter;
import org.opensearch.transport.grpc.proto.request.search.query.TermsQueryBuilderProtoConverter;
import org.opensearch.transport.grpc.proto.request.search.query.TermsSetQueryBuilderProtoConverter;
import org.opensearch.transport.grpc.proto.request.search.query.WildcardQueryBuilderProtoConverter;
import org.opensearch.transport.grpc.spi.QueryBuilderProtoConverter;
import org.opensearch.transport.grpc.spi.QueryBuilderProtoConverterRegistry;

@Singleton
public class QueryBuilderProtoConverterRegistryImpl
implements QueryBuilderProtoConverterRegistry {
    private static final Logger logger = LogManager.getLogger(QueryBuilderProtoConverterRegistryImpl.class);
    private final QueryBuilderProtoConverterSpiRegistry delegate = new QueryBuilderProtoConverterSpiRegistry();

    @Inject
    public QueryBuilderProtoConverterRegistryImpl() {
        this.registerBuiltInConverters();
    }

    protected void registerBuiltInConverters() {
        this.delegate.registerConverter(new MatchAllQueryBuilderProtoConverter());
        this.delegate.registerConverter(new MatchNoneQueryBuilderProtoConverter());
        this.delegate.registerConverter(new TermQueryBuilderProtoConverter());
        this.delegate.registerConverter(new TermsQueryBuilderProtoConverter());
        this.delegate.registerConverter(new MatchPhraseQueryBuilderProtoConverter());
        this.delegate.registerConverter(new MultiMatchQueryBuilderProtoConverter());
        this.delegate.registerConverter(new BoolQueryBuilderProtoConverter());
        this.delegate.registerConverter(new ScriptQueryBuilderProtoConverter());
        this.delegate.registerConverter(new ExistsQueryBuilderProtoConverter());
        this.delegate.registerConverter(new RegexpQueryBuilderProtoConverter());
        this.delegate.registerConverter(new WildcardQueryBuilderProtoConverter());
        this.delegate.registerConverter(new GeoBoundingBoxQueryBuilderProtoConverter());
        this.delegate.registerConverter(new GeoDistanceQueryBuilderProtoConverter());
        this.delegate.registerConverter(new NestedQueryBuilderProtoConverter());
        this.delegate.registerConverter(new IdsQueryBuilderProtoConverter());
        this.delegate.registerConverter(new RangeQueryBuilderProtoConverter());
        this.delegate.registerConverter(new TermsSetQueryBuilderProtoConverter());
        this.delegate.setRegistryOnAllConverters(this);
        logger.info("Registered {} built-in query converters", (Object)this.delegate.size());
    }

    public QueryBuilder fromProto(QueryContainer queryContainer) {
        return this.delegate.fromProto(queryContainer);
    }

    public void registerConverter(QueryBuilderProtoConverter converter) {
        this.delegate.registerConverter(converter);
    }

    public void updateRegistryOnAllConverters() {
        this.delegate.setRegistryOnAllConverters(this);
    }
}

