import { Command, Interfaces } from '@oclif/core';
/**
 * Comando per creare pacchetti Debian
 */
export default class Deb extends Command {
    here: string;
    pathSource: string;
    static args: {
        pathSource: Interfaces.Arg<string | undefined, Record<string, unknown>>;
    };
    static description: string;
    static flags: {
        help: Interfaces.BooleanFlag<void>;
        all: Interfaces.BooleanFlag<boolean>;
        release: Interfaces.OptionFlag<string | undefined, Interfaces.CustomOptions>;
        manpages: Interfaces.BooleanFlag<boolean>;
        verbose: Interfaces.BooleanFlag<boolean>;
    };
    static summary: string;
    /**
     * Metodo principale eseguito dal comando
     */
    run(): Promise<void>;
    /**
     * Crea un singolo pacchetto per una specifica architettura
     */
    createPackage(debArch: string, release: string, manpages: boolean, verbose: boolean, tempBuildRoot: string, finalReleasesDir: string): Promise<void>;
}
